# 2024-07-16 Triage Log

Fairly quiet week with the only pure regressions being small and coming from correctness fixes. The biggest single change came from turning off the `-Zenforce-type-length-limit` check which had positive impacts across many different benchmarks since the compiler is doing strictly less work.

Triage done by **@rylev**.
Revision range: [a2d58197..5572759b](https://perf.rust-lang.org/?start=a2d58197a766085856504328948c89a33a6a36e8&end=5572759b8d7012fa34eba47f4885c76fa06d9251&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.7%]    | 12    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.2%, 0.9%]    | 45    |
| Improvements ✅ <br /> (primary)   | -0.7% | [-1.5%, -0.2%]  | 37    |
| Improvements ✅ <br /> (secondary) | -3.3% | [-13.5%, -0.4%] | 21    |
| All ❌✅ (primary)                 | -0.4% | [-1.5%, 0.7%]   | 49    |


2 Regressions, 3 Improvements, 2 Mixed; 1 of them in rollups
56 artifact comparisons made in total

#### Regressions

Fix regression in the MIR lowering of or-patterns [#127028](https://github.com/rust-lang/rust/pull/127028) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f25e92bd42b14e45440c0a30a4ed751ea502f430&end=9dcaa7f92cf3ed0a9d2e93824025243533bb5541&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.3%, 1.2%] | 3     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.3%, 1.2%] | 3     |
- Given this is a correctness fix, and the regressions seem in line with previous historical performance (i.e., it regressed back to a previous baseline), I think it's safe to call this triaged


Avoid follow-up errors and ICEs after missing lifetime errors on data structures [#127311](https://github.com/rust-lang/rust/pull/127311) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fdf7ea6b5b1cac83c0f29e681202cf18bf25b01c&end=c92a8e4d4d7e8da53aa05309ef8d4fac2c9af52f&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.4%] | 8     |
| Regressions ❌ <br /> (secondary)  | 0.3% | [0.2%, 0.4%] | 16    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.4%] | 8     |
- Instruction counts go up, cycles do not (deeply nested multi is probably just noise in mono collection). In any case, this is a correctness fix so it seems like a small perf hit would be acceptable in any case.


#### Improvements

Fix `Parser::look_ahead` [#127636](https://github.com/rust-lang/rust/pull/127636) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5d76a13bbedebd773b4960432bff14f40acf3840&end=62c068feeafd1f4abbf87243d69cf8862e4dd277&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -2.4% | [-2.4%, -2.4%] | 1     |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.2%] | 3     |


Gate the type length limit check behind a nightly flag [#127670](https://github.com/rust-lang/rust/pull/127670) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a241cf1c49c46c57ee2ea9b19df4e7e2cc41449d&end=88fa119c77682e6d55ce21001cf761675cfebeae&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.4%, -0.2%] | 28    |
| Improvements ✅ <br /> (secondary) | -1.1% | [-1.5%, -0.4%] | 8     |
| All ❌✅ (primary)                 | -0.6% | [-1.4%, -0.2%] | 28    |


find_field does not need to be a query. [#127718](https://github.com/rust-lang/rust/pull/127718) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d9284afea99e0969a0e692b9e9fd61ea4ba21366&end=8b72d7a9d7a02cb4f2b21c1497651c84a912550a&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -     | -               | 0     |
| Improvements ✅ <br /> (secondary) | -7.5% | [-13.5%, -2.7%] | 9     |
| All ❌✅ (primary)                 | -     | -               | 0     |


#### Mixed

Rollup of 7 pull requests [#127580](https://github.com/rust-lang/rust/pull/127580) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b215beb567857000fdaa868cbb78702bc5ee0ee9&end=c092b289764530221d09e000a789222bddb2c53c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 2.6%  | [2.6%, 2.6%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.0%, -0.2%] | 9     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.6% | [-1.0%, -0.2%] | 9     |
- Noise


Only track mentioned places for jump threading [#127087](https://github.com/rust-lang/rust/pull/127087) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8a63c84af5e7a201239e87d2175128907495b028&end=0ffbddd09e02a00b762d838ea1598bfa89dd1668&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.4%, 0.6%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 1.1%  | [0.2%, 1.6%]   | 7     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.3%, -0.2%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-2.0%, -0.3%] | 8     |
| All ❌✅ (primary)                 | -0.2% | [-1.3%, 0.6%]  | 9     |
- The perf impact was expected given the pre-merge runs and is less severe than it was pre-merge.

