# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
import datetime
from typing import Any, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class Column(_serialization.Model):
    """Query result column descriptor.

    All required parameters must be populated in order to send to server.

    :ivar name: Column name. Required.
    :vartype name: str
    :ivar type: Column data type. Required. Known values are: "string", "integer", "number",
     "boolean", and "object".
    :vartype type: str or ~azure.mgmt.resourcegraph.models.ColumnDataType
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: str, type: Union[str, "_models.ColumnDataType"], **kwargs: Any) -> None:
        """
        :keyword name: Column name. Required.
        :paramtype name: str
        :keyword type: Column data type. Required. Known values are: "string", "integer", "number",
         "boolean", and "object".
        :paramtype type: str or ~azure.mgmt.resourcegraph.models.ColumnDataType
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class Error(_serialization.Model):
    """Error details.

    All required parameters must be populated in order to send to server.

    :ivar code: Error code identifying the specific error. Required.
    :vartype code: str
    :ivar message: A human readable error message. Required.
    :vartype message: str
    :ivar details: Error details.
    :vartype details: list[~azure.mgmt.resourcegraph.models.ErrorDetails]
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetails]"},
    }

    def __init__(
        self, *, code: str, message: str, details: Optional[list["_models.ErrorDetails"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code: Error code identifying the specific error. Required.
        :paramtype code: str
        :keyword message: A human readable error message. Required.
        :paramtype message: str
        :keyword details: Error details.
        :paramtype details: list[~azure.mgmt.resourcegraph.models.ErrorDetails]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details


class ErrorDetails(_serialization.Model):
    """Error details.

    All required parameters must be populated in order to send to server.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar code: Error code identifying the specific error. Required.
    :vartype code: str
    :ivar message: A human readable error message. Required.
    :vartype message: str
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, code: str, message: str, additional_properties: Optional[dict[str, JSON]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword code: Error code identifying the specific error. Required.
        :paramtype code: str
        :keyword message: A human readable error message. Required.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.code = code
        self.message = message


class ErrorFieldContract(_serialization.Model):
    """Error Field contract.

    :ivar code: Property level error code.
    :vartype code: str
    :ivar message: Human-readable representation of property-level error.
    :vartype message: str
    :ivar target: Property name.
    :vartype target: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, message: Optional[str] = None, target: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code: Property level error code.
        :paramtype code: str
        :keyword message: Human-readable representation of property-level error.
        :paramtype message: str
        :keyword target: Property name.
        :paramtype target: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target


class ErrorResponse(_serialization.Model):
    """An error response from the API.

    All required parameters must be populated in order to send to server.

    :ivar error: Error information. Required.
    :vartype error: ~azure.mgmt.resourcegraph.models.Error
    """

    _validation = {
        "error": {"required": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(self, *, error: "_models.Error", **kwargs: Any) -> None:
        """
        :keyword error: Error information. Required.
        :paramtype error: ~azure.mgmt.resourcegraph.models.Error
        """
        super().__init__(**kwargs)
        self.error = error


class Facet(_serialization.Model):
    """A facet containing additional statistics on the response of a query. Can be either FacetResult
    or FacetError.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FacetError, FacetResult

    All required parameters must be populated in order to send to server.

    :ivar expression: Facet expression, same as in the corresponding facet request. Required.
    :vartype expression: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    """

    _validation = {
        "expression": {"required": True},
        "result_type": {"required": True},
    }

    _attribute_map = {
        "expression": {"key": "expression", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
    }

    _subtype_map = {"result_type": {"FacetError": "FacetError", "FacetResult": "FacetResult"}}

    def __init__(self, *, expression: str, **kwargs: Any) -> None:
        """
        :keyword expression: Facet expression, same as in the corresponding facet request. Required.
        :paramtype expression: str
        """
        super().__init__(**kwargs)
        self.expression = expression
        self.result_type: Optional[str] = None


class FacetError(Facet):
    """A facet whose execution resulted in an error.

    All required parameters must be populated in order to send to server.

    :ivar expression: Facet expression, same as in the corresponding facet request. Required.
    :vartype expression: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar errors: An array containing detected facet errors with details. Required.
    :vartype errors: list[~azure.mgmt.resourcegraph.models.ErrorDetails]
    """

    _validation = {
        "expression": {"required": True},
        "result_type": {"required": True},
        "errors": {"required": True},
    }

    _attribute_map = {
        "expression": {"key": "expression", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "errors": {"key": "errors", "type": "[ErrorDetails]"},
    }

    def __init__(self, *, expression: str, errors: list["_models.ErrorDetails"], **kwargs: Any) -> None:
        """
        :keyword expression: Facet expression, same as in the corresponding facet request. Required.
        :paramtype expression: str
        :keyword errors: An array containing detected facet errors with details. Required.
        :paramtype errors: list[~azure.mgmt.resourcegraph.models.ErrorDetails]
        """
        super().__init__(expression=expression, **kwargs)
        self.result_type: str = "FacetError"
        self.errors = errors


class FacetRequest(_serialization.Model):
    """A request to compute additional statistics (facets) over the query results.

    All required parameters must be populated in order to send to server.

    :ivar expression: The column or list of columns to summarize by. Required.
    :vartype expression: str
    :ivar options: The options for facet evaluation.
    :vartype options: ~azure.mgmt.resourcegraph.models.FacetRequestOptions
    """

    _validation = {
        "expression": {"required": True},
    }

    _attribute_map = {
        "expression": {"key": "expression", "type": "str"},
        "options": {"key": "options", "type": "FacetRequestOptions"},
    }

    def __init__(
        self, *, expression: str, options: Optional["_models.FacetRequestOptions"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword expression: The column or list of columns to summarize by. Required.
        :paramtype expression: str
        :keyword options: The options for facet evaluation.
        :paramtype options: ~azure.mgmt.resourcegraph.models.FacetRequestOptions
        """
        super().__init__(**kwargs)
        self.expression = expression
        self.options = options


class FacetRequestOptions(_serialization.Model):
    """The options for facet evaluation.

    :ivar sort_by: The column name or query expression to sort on. Defaults to count if not
     present.
    :vartype sort_by: str
    :ivar sort_order: The sorting order by the selected column (count by default). Known values
     are: "asc" and "desc".
    :vartype sort_order: str or ~azure.mgmt.resourcegraph.models.FacetSortOrder
    :ivar filter: Specifies the filter condition for the 'where' clause which will be run on main
     query's result, just before the actual faceting.
    :vartype filter: str
    :ivar top: The maximum number of facet rows that should be returned.
    :vartype top: int
    """

    _validation = {
        "top": {"maximum": 1000, "minimum": 1},
    }

    _attribute_map = {
        "sort_by": {"key": "sortBy", "type": "str"},
        "sort_order": {"key": "sortOrder", "type": "str"},
        "filter": {"key": "filter", "type": "str"},
        "top": {"key": "$top", "type": "int"},
    }

    def __init__(
        self,
        *,
        sort_by: Optional[str] = None,
        sort_order: Union[str, "_models.FacetSortOrder"] = "desc",
        filter: Optional[str] = None,  # pylint: disable=redefined-builtin
        top: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sort_by: The column name or query expression to sort on. Defaults to count if not
         present.
        :paramtype sort_by: str
        :keyword sort_order: The sorting order by the selected column (count by default). Known values
         are: "asc" and "desc".
        :paramtype sort_order: str or ~azure.mgmt.resourcegraph.models.FacetSortOrder
        :keyword filter: Specifies the filter condition for the 'where' clause which will be run on
         main query's result, just before the actual faceting.
        :paramtype filter: str
        :keyword top: The maximum number of facet rows that should be returned.
        :paramtype top: int
        """
        super().__init__(**kwargs)
        self.sort_by = sort_by
        self.sort_order = sort_order
        self.filter = filter
        self.top = top


class FacetResult(Facet):
    """Successfully executed facet containing additional statistics on the response of a query.

    All required parameters must be populated in order to send to server.

    :ivar expression: Facet expression, same as in the corresponding facet request. Required.
    :vartype expression: str
    :ivar result_type: Result type. Required.
    :vartype result_type: str
    :ivar total_records: Number of total records in the facet results. Required.
    :vartype total_records: int
    :ivar count: Number of records returned in the facet response. Required.
    :vartype count: int
    :ivar data: A JObject array or Table containing the desired facets. Only present if the facet
     is valid. Required.
    :vartype data: JSON
    """

    _validation = {
        "expression": {"required": True},
        "result_type": {"required": True},
        "total_records": {"required": True},
        "count": {"required": True},
        "data": {"required": True},
    }

    _attribute_map = {
        "expression": {"key": "expression", "type": "str"},
        "result_type": {"key": "resultType", "type": "str"},
        "total_records": {"key": "totalRecords", "type": "int"},
        "count": {"key": "count", "type": "int"},
        "data": {"key": "data", "type": "object"},
    }

    def __init__(self, *, expression: str, total_records: int, count: int, data: JSON, **kwargs: Any) -> None:
        """
        :keyword expression: Facet expression, same as in the corresponding facet request. Required.
        :paramtype expression: str
        :keyword total_records: Number of total records in the facet results. Required.
        :paramtype total_records: int
        :keyword count: Number of records returned in the facet response. Required.
        :paramtype count: int
        :keyword data: A JObject array or Table containing the desired facets. Only present if the
         facet is valid. Required.
        :paramtype data: JSON
        """
        super().__init__(expression=expression, **kwargs)
        self.result_type: str = "FacetResult"
        self.total_records = total_records
        self.count = count
        self.data = data


class GraphQueryError(_serialization.Model):
    """Error message body that will indicate why the operation failed.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.resourcegraph.models.GraphQueryErrorError
    """

    _attribute_map = {
        "error": {"key": "error", "type": "GraphQueryErrorError"},
    }

    def __init__(self, *, error: Optional["_models.GraphQueryErrorError"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.resourcegraph.models.GraphQueryErrorError
        """
        super().__init__(**kwargs)
        self.error = error


class GraphQueryErrorError(_serialization.Model):
    """The error object.

    :ivar code: Service-defined error code. This code serves as a sub-status for the HTTP error
     code specified in the response.
    :vartype code: str
    :ivar message: Human-readable representation of the error.
    :vartype message: str
    :ivar details: The list of invalid fields send in request, in case of validation error.
    :vartype details: list[~azure.mgmt.resourcegraph.models.ErrorFieldContract]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[ErrorFieldContract]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        details: Optional[list["_models.ErrorFieldContract"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: Service-defined error code. This code serves as a sub-status for the HTTP error
         code specified in the response.
        :paramtype code: str
        :keyword message: Human-readable representation of the error.
        :paramtype message: str
        :keyword details: The list of invalid fields send in request, in case of validation error.
        :paramtype details: list[~azure.mgmt.resourcegraph.models.ErrorFieldContract]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details


class GraphQueryListResult(_serialization.Model):
    """Graph query list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link: URL to fetch the next set of queries.
    :vartype next_link: str
    :ivar value: An array of graph queries.
    :vartype value: list[~azure.mgmt.resourcegraph.models.GraphQueryResource]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[GraphQueryResource]"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: URL to fetch the next set of queries.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value: Optional[list["_models.GraphQueryResource"]] = None


class Resource(_serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name. This is GUID value. The display name should be assigned within
     properties field.
    :vartype name: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar etag: This will be used to handle Optimistic Concurrency. If not present, it will always
     overwrite the existing resource without checking conflict.
    :vartype etag: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        etag: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword etag: This will be used to handle Optimistic Concurrency. If not present, it will
         always overwrite the existing resource without checking conflict.
        :paramtype etag: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.location = location
        self.type: Optional[str] = None
        self.etag = etag
        self.tags = tags


class GraphQueryResource(Resource):
    """Graph Query entity definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name. This is GUID value. The display name should be assigned within
     properties field.
    :vartype name: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar etag: This will be used to handle Optimistic Concurrency. If not present, it will always
     overwrite the existing resource without checking conflict.
    :vartype etag: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar time_modified: Date and time in UTC of the last modification that was made to this graph
     query definition.
    :vartype time_modified: ~datetime.datetime
    :ivar description: The description of a graph query.
    :vartype description: str
    :ivar query: KQL query that will be graph.
    :vartype query: str
    :ivar result_kind: Enum indicating a type of graph query. "basic"
    :vartype result_kind: str or ~azure.mgmt.resourcegraph.models.ResultKind
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "time_modified": {"readonly": True},
        "result_kind": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "time_modified": {"key": "properties.timeModified", "type": "iso-8601"},
        "description": {"key": "properties.description", "type": "str"},
        "query": {"key": "properties.query", "type": "str"},
        "result_kind": {"key": "properties.resultKind", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        etag: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        description: Optional[str] = None,
        query: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword etag: This will be used to handle Optimistic Concurrency. If not present, it will
         always overwrite the existing resource without checking conflict.
        :paramtype etag: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of a graph query.
        :paramtype description: str
        :keyword query: KQL query that will be graph.
        :paramtype query: str
        """
        super().__init__(location=location, etag=etag, tags=tags, **kwargs)
        self.time_modified: Optional[datetime.datetime] = None
        self.description = description
        self.query = query
        self.result_kind: Optional[Union[str, "_models.ResultKind"]] = None


class GraphQueryUpdateParameters(_serialization.Model):
    """The parameters that can be provided when updating workbook properties properties.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: This will be used to handle Optimistic Concurrency. If not present, it will always
     overwrite the existing resource without checking conflict.
    :vartype etag: str
    :ivar description: The description of a graph query.
    :vartype description: str
    :ivar query: KQL query that will be graph.
    :vartype query: str
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "query": {"key": "properties.query", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        etag: Optional[str] = None,
        description: Optional[str] = None,
        query: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: This will be used to handle Optimistic Concurrency. If not present, it will
         always overwrite the existing resource without checking conflict.
        :paramtype etag: str
        :keyword description: The description of a graph query.
        :paramtype description: str
        :keyword query: KQL query that will be graph.
        :paramtype query: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.etag = etag
        self.description = description
        self.query = query


class Operation(_serialization.Model):
    """Resource Graph REST API operation definition.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display: ~azure.mgmt.resourcegraph.models.OperationDisplay
    :ivar origin: The origin of operations.
    :vartype origin: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display metadata associated with the operation.
        :paramtype display: ~azure.mgmt.resourcegraph.models.OperationDisplay
        :keyword origin: The origin of operations.
        :paramtype origin: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin


class OperationDisplay(_serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Service provider: Microsoft Resource Graph.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed etc.
    :vartype resource: str
    :ivar operation: Type of operation: get, read, delete, etc.
    :vartype operation: str
    :ivar description: Description for the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Service provider: Microsoft Resource Graph.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed etc.
        :paramtype resource: str
        :keyword operation: Type of operation: get, read, delete, etc.
        :paramtype operation: str
        :keyword description: Description for the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """Result of the request to list Resource Graph operations. It contains a list of operations and a
    URL link to get the next set of results.

    :ivar value: List of Resource Graph operations supported by the Resource Graph resource
     provider.
    :vartype value: list[~azure.mgmt.resourcegraph.models.Operation]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
    }

    def __init__(self, *, value: Optional[list["_models.Operation"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of Resource Graph operations supported by the Resource Graph resource
         provider.
        :paramtype value: list[~azure.mgmt.resourcegraph.models.Operation]
        """
        super().__init__(**kwargs)
        self.value = value


class QueryRequest(_serialization.Model):
    """Describes a query to be executed.

    All required parameters must be populated in order to send to server.

    :ivar subscriptions: Azure subscriptions against which to execute the query.
    :vartype subscriptions: list[str]
    :ivar management_groups: Azure management groups against which to execute the query. Example: [
     'mg1', 'mg2' ].
    :vartype management_groups: list[str]
    :ivar query: The resources query. Required.
    :vartype query: str
    :ivar options: The query evaluation options.
    :vartype options: ~azure.mgmt.resourcegraph.models.QueryRequestOptions
    :ivar facets: An array of facet requests to be computed against the query result.
    :vartype facets: list[~azure.mgmt.resourcegraph.models.FacetRequest]
    """

    _validation = {
        "query": {"required": True},
    }

    _attribute_map = {
        "subscriptions": {"key": "subscriptions", "type": "[str]"},
        "management_groups": {"key": "managementGroups", "type": "[str]"},
        "query": {"key": "query", "type": "str"},
        "options": {"key": "options", "type": "QueryRequestOptions"},
        "facets": {"key": "facets", "type": "[FacetRequest]"},
    }

    def __init__(
        self,
        *,
        query: str,
        subscriptions: Optional[list[str]] = None,
        management_groups: Optional[list[str]] = None,
        options: Optional["_models.QueryRequestOptions"] = None,
        facets: Optional[list["_models.FacetRequest"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword subscriptions: Azure subscriptions against which to execute the query.
        :paramtype subscriptions: list[str]
        :keyword management_groups: Azure management groups against which to execute the query.
         Example: [ 'mg1', 'mg2' ].
        :paramtype management_groups: list[str]
        :keyword query: The resources query. Required.
        :paramtype query: str
        :keyword options: The query evaluation options.
        :paramtype options: ~azure.mgmt.resourcegraph.models.QueryRequestOptions
        :keyword facets: An array of facet requests to be computed against the query result.
        :paramtype facets: list[~azure.mgmt.resourcegraph.models.FacetRequest]
        """
        super().__init__(**kwargs)
        self.subscriptions = subscriptions
        self.management_groups = management_groups
        self.query = query
        self.options = options
        self.facets = facets


class QueryRequestOptions(_serialization.Model):
    """The options for query evaluation.

    :ivar skip_token: Continuation token for pagination, capturing the next page size and offset,
     as well as the context of the query.
    :vartype skip_token: str
    :ivar top: The maximum number of rows that the query should return. Overrides the page size
     when ``$skipToken`` property is present.
    :vartype top: int
    :ivar skip: The number of rows to skip from the beginning of the results. Overrides the next
     page offset when ``$skipToken`` property is present.
    :vartype skip: int
    :ivar result_format: Defines in which format query result returned. Known values are: "table"
     and "objectArray".
    :vartype result_format: str or ~azure.mgmt.resourcegraph.models.ResultFormat
    :ivar allow_partial_scopes: Only applicable for tenant and management group level queries to
     decide whether to allow partial scopes for result in case the number of subscriptions exceed
     allowed limits.
    :vartype allow_partial_scopes: bool
    """

    _validation = {
        "top": {"maximum": 1000, "minimum": 1},
        "skip": {"minimum": 0},
    }

    _attribute_map = {
        "skip_token": {"key": "$skipToken", "type": "str"},
        "top": {"key": "$top", "type": "int"},
        "skip": {"key": "$skip", "type": "int"},
        "result_format": {"key": "resultFormat", "type": "str"},
        "allow_partial_scopes": {"key": "allowPartialScopes", "type": "bool"},
    }

    def __init__(
        self,
        *,
        skip_token: Optional[str] = None,
        top: Optional[int] = None,
        skip: Optional[int] = None,
        result_format: Union[str, "_models.ResultFormat"] = "objectArray",
        allow_partial_scopes: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword skip_token: Continuation token for pagination, capturing the next page size and
         offset, as well as the context of the query.
        :paramtype skip_token: str
        :keyword top: The maximum number of rows that the query should return. Overrides the page size
         when ``$skipToken`` property is present.
        :paramtype top: int
        :keyword skip: The number of rows to skip from the beginning of the results. Overrides the next
         page offset when ``$skipToken`` property is present.
        :paramtype skip: int
        :keyword result_format: Defines in which format query result returned. Known values are:
         "table" and "objectArray".
        :paramtype result_format: str or ~azure.mgmt.resourcegraph.models.ResultFormat
        :keyword allow_partial_scopes: Only applicable for tenant and management group level queries to
         decide whether to allow partial scopes for result in case the number of subscriptions exceed
         allowed limits.
        :paramtype allow_partial_scopes: bool
        """
        super().__init__(**kwargs)
        self.skip_token = skip_token
        self.top = top
        self.skip = skip
        self.result_format = result_format
        self.allow_partial_scopes = allow_partial_scopes


class QueryResponse(_serialization.Model):
    """Query result.

    All required parameters must be populated in order to send to server.

    :ivar total_records: Number of total records matching the query. Required.
    :vartype total_records: int
    :ivar count: Number of records returned in the current response. In the case of paging, this is
     the number of records in the current page. Required.
    :vartype count: int
    :ivar result_truncated: Indicates whether the query results are truncated. Required. Known
     values are: "true" and "false".
    :vartype result_truncated: str or ~azure.mgmt.resourcegraph.models.ResultTruncated
    :ivar skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :vartype skip_token: str
    :ivar data: Query output in JObject array or Table format. Required.
    :vartype data: JSON
    :ivar facets: Query facets.
    :vartype facets: list[~azure.mgmt.resourcegraph.models.Facet]
    """

    _validation = {
        "total_records": {"required": True},
        "count": {"required": True},
        "result_truncated": {"required": True},
        "data": {"required": True},
    }

    _attribute_map = {
        "total_records": {"key": "totalRecords", "type": "int"},
        "count": {"key": "count", "type": "int"},
        "result_truncated": {"key": "resultTruncated", "type": "str"},
        "skip_token": {"key": "$skipToken", "type": "str"},
        "data": {"key": "data", "type": "object"},
        "facets": {"key": "facets", "type": "[Facet]"},
    }

    def __init__(
        self,
        *,
        total_records: int,
        count: int,
        result_truncated: Union[str, "_models.ResultTruncated"],
        data: JSON,
        skip_token: Optional[str] = None,
        facets: Optional[list["_models.Facet"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword total_records: Number of total records matching the query. Required.
        :paramtype total_records: int
        :keyword count: Number of records returned in the current response. In the case of paging, this
         is the number of records in the current page. Required.
        :paramtype count: int
        :keyword result_truncated: Indicates whether the query results are truncated. Required. Known
         values are: "true" and "false".
        :paramtype result_truncated: str or ~azure.mgmt.resourcegraph.models.ResultTruncated
        :keyword skip_token: When present, the value can be passed to a subsequent query call (together
         with the same query and scopes used in the current request) to retrieve the next page of data.
        :paramtype skip_token: str
        :keyword data: Query output in JObject array or Table format. Required.
        :paramtype data: JSON
        :keyword facets: Query facets.
        :paramtype facets: list[~azure.mgmt.resourcegraph.models.Facet]
        """
        super().__init__(**kwargs)
        self.total_records = total_records
        self.count = count
        self.result_truncated = result_truncated
        self.skip_token = skip_token
        self.data = data
        self.facets = facets


class Table(_serialization.Model):
    """Query output in tabular format.

    All required parameters must be populated in order to send to server.

    :ivar columns: Query result column descriptors. Required.
    :vartype columns: list[~azure.mgmt.resourcegraph.models.Column]
    :ivar rows: Query result rows. Required.
    :vartype rows: list[list[JSON]]
    """

    _validation = {
        "columns": {"required": True},
        "rows": {"required": True},
    }

    _attribute_map = {
        "columns": {"key": "columns", "type": "[Column]"},
        "rows": {"key": "rows", "type": "[[object]]"},
    }

    def __init__(self, *, columns: list["_models.Column"], rows: list[list[JSON]], **kwargs: Any) -> None:
        """
        :keyword columns: Query result column descriptors. Required.
        :paramtype columns: list[~azure.mgmt.resourcegraph.models.Column]
        :keyword rows: Query result rows. Required.
        :paramtype rows: list[list[JSON]]
        """
        super().__init__(**kwargs)
        self.columns = columns
        self.rows = rows
