; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-unknown-unknown -O3 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=DEFAULT
; RUN: llc -mtriple=x86_64-unknown-unknown -O3 -cgp-icmp-eq2icmp-st -verify-machineinstrs < %s | FileCheck %s --check-prefixes=EQ2ICMP

; Test cases are generated from:
; long long NAME(PARAM a, PARAM b) {
;   if (LHS > RHS)
;     return b;
;   if (LHS < RHS)
;     return a;\
;   return a * b;
; }
; Please note funtion name is defined as <PARAM>_<LHS>_<RHS>. Take ll_a_op_b__1
; for example. ll is PARAM, a_op_b (i.e., a << b) is LHS, _1 (i.e., -1) is RHS.

target datalayout = "e-m:e-i64:64-n32:64"

define i64 @ll_a_op_b__2(i64 %a, i64 %b) {
; DEFAULT-LABEL: ll_a_op_b__2:
; DEFAULT:       # %bb.0: # %entry
; DEFAULT-NEXT:    movq %rsi, %rcx
; DEFAULT-NEXT:    movq %rdi, %rax
; DEFAULT-NEXT:    shlq %cl, %rax
; DEFAULT-NEXT:    cmpq $-2, %rax
; DEFAULT-NEXT:    jle .LBB0_1
; DEFAULT-NEXT:  # %bb.2: # %return
; DEFAULT-NEXT:    movq %rcx, %rax
; DEFAULT-NEXT:    retq
; DEFAULT-NEXT:  .LBB0_1: # %if.end
; DEFAULT-NEXT:    movl $1, %eax
; DEFAULT-NEXT:    cmoveq %rcx, %rax
; DEFAULT-NEXT:    imulq %rdi, %rax
; DEFAULT-NEXT:    retq
;
; EQ2ICMP-LABEL: ll_a_op_b__2:
; EQ2ICMP:       # %bb.0: # %entry
; EQ2ICMP-NEXT:    movq %rsi, %rax
; EQ2ICMP-NEXT:    movq %rdi, %rdx
; EQ2ICMP-NEXT:    movl %eax, %ecx
; EQ2ICMP-NEXT:    shlq %cl, %rdx
; EQ2ICMP-NEXT:    cmpq $-2, %rdx
; EQ2ICMP-NEXT:    jg .LBB0_2
; EQ2ICMP-NEXT:  # %bb.1: # %if.end
; EQ2ICMP-NEXT:    movl $1, %ecx
; EQ2ICMP-NEXT:    cmovlq %rcx, %rax
; EQ2ICMP-NEXT:    imulq %rdi, %rax
; EQ2ICMP-NEXT:  .LBB0_2: # %return
; EQ2ICMP-NEXT:    retq
entry:
  %shl = shl i64 %a, %b
  %cmp = icmp sgt i64 %shl, -2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i64 %shl, -2
  %mul = select i1 %cmp2, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a_op_b__1(i64 %a, i64 %b) {
; DEFAULT-LABEL: ll_a_op_b__1:
; DEFAULT:       # %bb.0: # %entry
; DEFAULT-NEXT:    movq %rsi, %rcx
; DEFAULT-NEXT:    movq %rdi, %rax
; DEFAULT-NEXT:    shlq %cl, %rax
; DEFAULT-NEXT:    testq %rax, %rax
; DEFAULT-NEXT:    js .LBB1_1
; DEFAULT-NEXT:  # %bb.2: # %return
; DEFAULT-NEXT:    movq %rcx, %rax
; DEFAULT-NEXT:    retq
; DEFAULT-NEXT:  .LBB1_1: # %if.end
; DEFAULT-NEXT:    cmpq $-1, %rax
; DEFAULT-NEXT:    movl $1, %eax
; DEFAULT-NEXT:    cmoveq %rcx, %rax
; DEFAULT-NEXT:    imulq %rdi, %rax
; DEFAULT-NEXT:    retq
;
; EQ2ICMP-LABEL: ll_a_op_b__1:
; EQ2ICMP:       # %bb.0: # %entry
; EQ2ICMP-NEXT:    movq %rsi, %rax
; EQ2ICMP-NEXT:    movq %rdi, %rdx
; EQ2ICMP-NEXT:    movl %eax, %ecx
; EQ2ICMP-NEXT:    shlq %cl, %rdx
; EQ2ICMP-NEXT:    testq %rdx, %rdx
; EQ2ICMP-NEXT:    js .LBB1_1
; EQ2ICMP-NEXT:  # %bb.2: # %return
; EQ2ICMP-NEXT:    retq
; EQ2ICMP-NEXT:  .LBB1_1: # %if.end
; EQ2ICMP-NEXT:    cmpq $-1, %rdx
; EQ2ICMP-NEXT:    movl $1, %ecx
; EQ2ICMP-NEXT:    cmovlq %rcx, %rax
; EQ2ICMP-NEXT:    imulq %rdi, %rax
; EQ2ICMP-NEXT:    retq
entry:
  %shl = shl i64 %a, %b
  %cmp = icmp sgt i64 %shl, -1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i64 %shl, -1
  %mul = select i1 %cmp2, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a_op_b_0(i64 %a, i64 %b) {
; DEFAULT-LABEL: ll_a_op_b_0:
; DEFAULT:       # %bb.0: # %entry
; DEFAULT-NEXT:    movq %rsi, %rcx
; DEFAULT-NEXT:    movq %rdi, %rax
; DEFAULT-NEXT:    shlq %cl, %rax
; DEFAULT-NEXT:    testq %rax, %rax
; DEFAULT-NEXT:    jle .LBB2_1
; DEFAULT-NEXT:  # %bb.2: # %return
; DEFAULT-NEXT:    movq %rcx, %rax
; DEFAULT-NEXT:    retq
; DEFAULT-NEXT:  .LBB2_1: # %if.end
; DEFAULT-NEXT:    movl $1, %eax
; DEFAULT-NEXT:    cmoveq %rcx, %rax
; DEFAULT-NEXT:    imulq %rdi, %rax
; DEFAULT-NEXT:    retq
;
; EQ2ICMP-LABEL: ll_a_op_b_0:
; EQ2ICMP:       # %bb.0: # %entry
; EQ2ICMP-NEXT:    movq %rsi, %rax
; EQ2ICMP-NEXT:    movq %rdi, %rdx
; EQ2ICMP-NEXT:    movl %eax, %ecx
; EQ2ICMP-NEXT:    shlq %cl, %rdx
; EQ2ICMP-NEXT:    testq %rdx, %rdx
; EQ2ICMP-NEXT:    jle .LBB2_1
; EQ2ICMP-NEXT:  # %bb.2: # %return
; EQ2ICMP-NEXT:    retq
; EQ2ICMP-NEXT:  .LBB2_1: # %if.end
; EQ2ICMP-NEXT:    movl $1, %ecx
; EQ2ICMP-NEXT:    cmovsq %rcx, %rax
; EQ2ICMP-NEXT:    imulq %rdi, %rax
; EQ2ICMP-NEXT:    retq
entry:
  %shl = shl i64 %a, %b
  %cmp = icmp sgt i64 %shl, 0
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i64 %shl, 0
  %mul = select i1 %cmp2, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a_op_b_1(i64 %a, i64 %b) {
; DEFAULT-LABEL: ll_a_op_b_1:
; DEFAULT:       # %bb.0: # %entry
; DEFAULT-NEXT:    movq %rsi, %rcx
; DEFAULT-NEXT:    movq %rdi, %rax
; DEFAULT-NEXT:    shlq %cl, %rax
; DEFAULT-NEXT:    cmpq $1, %rax
; DEFAULT-NEXT:    jle .LBB3_1
; DEFAULT-NEXT:  # %bb.2: # %return
; DEFAULT-NEXT:    movq %rcx, %rax
; DEFAULT-NEXT:    retq
; DEFAULT-NEXT:  .LBB3_1: # %if.end
; DEFAULT-NEXT:    movl $1, %eax
; DEFAULT-NEXT:    cmoveq %rcx, %rax
; DEFAULT-NEXT:    imulq %rdi, %rax
; DEFAULT-NEXT:    retq
;
; EQ2ICMP-LABEL: ll_a_op_b_1:
; EQ2ICMP:       # %bb.0: # %entry
; EQ2ICMP-NEXT:    movq %rsi, %rax
; EQ2ICMP-NEXT:    movq %rdi, %rdx
; EQ2ICMP-NEXT:    movl %eax, %ecx
; EQ2ICMP-NEXT:    shlq %cl, %rdx
; EQ2ICMP-NEXT:    cmpq $1, %rdx
; EQ2ICMP-NEXT:    jg .LBB3_2
; EQ2ICMP-NEXT:  # %bb.1: # %if.end
; EQ2ICMP-NEXT:    movl $1, %ecx
; EQ2ICMP-NEXT:    cmovlq %rcx, %rax
; EQ2ICMP-NEXT:    imulq %rdi, %rax
; EQ2ICMP-NEXT:  .LBB3_2: # %return
; EQ2ICMP-NEXT:    retq
entry:
  %shl = shl i64 %a, %b
  %cmp = icmp sgt i64 %shl, 1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i64 %shl, 1
  %mul = select i1 %cmp2, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a_op_b_2(i64 %a, i64 %b) {
; DEFAULT-LABEL: ll_a_op_b_2:
; DEFAULT:       # %bb.0: # %entry
; DEFAULT-NEXT:    movq %rsi, %rcx
; DEFAULT-NEXT:    movq %rdi, %rax
; DEFAULT-NEXT:    shlq %cl, %rax
; DEFAULT-NEXT:    cmpq $2, %rax
; DEFAULT-NEXT:    jle .LBB4_1
; DEFAULT-NEXT:  # %bb.2: # %return
; DEFAULT-NEXT:    movq %rcx, %rax
; DEFAULT-NEXT:    retq
; DEFAULT-NEXT:  .LBB4_1: # %if.end
; DEFAULT-NEXT:    movl $1, %eax
; DEFAULT-NEXT:    cmoveq %rcx, %rax
; DEFAULT-NEXT:    imulq %rdi, %rax
; DEFAULT-NEXT:    retq
;
; EQ2ICMP-LABEL: ll_a_op_b_2:
; EQ2ICMP:       # %bb.0: # %entry
; EQ2ICMP-NEXT:    movq %rsi, %rax
; EQ2ICMP-NEXT:    movq %rdi, %rdx
; EQ2ICMP-NEXT:    movl %eax, %ecx
; EQ2ICMP-NEXT:    shlq %cl, %rdx
; EQ2ICMP-NEXT:    cmpq $2, %rdx
; EQ2ICMP-NEXT:    jg .LBB4_2
; EQ2ICMP-NEXT:  # %bb.1: # %if.end
; EQ2ICMP-NEXT:    movl $1, %ecx
; EQ2ICMP-NEXT:    cmovlq %rcx, %rax
; EQ2ICMP-NEXT:    imulq %rdi, %rax
; EQ2ICMP-NEXT:  .LBB4_2: # %return
; EQ2ICMP-NEXT:    retq
entry:
  %shl = shl i64 %a, %b
  %cmp = icmp sgt i64 %shl, 2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i64 %shl, 2
  %mul = select i1 %cmp2, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a__2(i64 %a, i64 %b) {
; DEFAULT-LABEL: ll_a__2:
; DEFAULT:       # %bb.0: # %entry
; DEFAULT-NEXT:    cmpq $-2, %rdi
; DEFAULT-NEXT:    jle .LBB5_1
; DEFAULT-NEXT:  # %bb.2: # %return
; DEFAULT-NEXT:    movq %rsi, %rax
; DEFAULT-NEXT:    retq
; DEFAULT-NEXT:  .LBB5_1: # %if.end
; DEFAULT-NEXT:    movl $1, %eax
; DEFAULT-NEXT:    cmoveq %rsi, %rax
; DEFAULT-NEXT:    imulq %rdi, %rax
; DEFAULT-NEXT:    retq
;
; EQ2ICMP-LABEL: ll_a__2:
; EQ2ICMP:       # %bb.0: # %entry
; EQ2ICMP-NEXT:    movq %rsi, %rax
; EQ2ICMP-NEXT:    cmpq $-2, %rdi
; EQ2ICMP-NEXT:    jg .LBB5_2
; EQ2ICMP-NEXT:  # %bb.1: # %if.end
; EQ2ICMP-NEXT:    movl $1, %ecx
; EQ2ICMP-NEXT:    cmovlq %rcx, %rax
; EQ2ICMP-NEXT:    imulq %rdi, %rax
; EQ2ICMP-NEXT:  .LBB5_2: # %return
; EQ2ICMP-NEXT:    retq
entry:
  %cmp = icmp sgt i64 %a, -2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i64 %a, -2
  %mul = select i1 %cmp1, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a__1(i64 %a, i64 %b) {
; DEFAULT-LABEL: ll_a__1:
; DEFAULT:       # %bb.0: # %entry
; DEFAULT-NEXT:    testq %rdi, %rdi
; DEFAULT-NEXT:    js .LBB6_1
; DEFAULT-NEXT:  # %bb.2: # %return
; DEFAULT-NEXT:    movq %rsi, %rax
; DEFAULT-NEXT:    retq
; DEFAULT-NEXT:  .LBB6_1: # %if.end
; DEFAULT-NEXT:    cmpq $-1, %rdi
; DEFAULT-NEXT:    movl $1, %eax
; DEFAULT-NEXT:    cmoveq %rsi, %rax
; DEFAULT-NEXT:    imulq %rdi, %rax
; DEFAULT-NEXT:    retq
;
; EQ2ICMP-LABEL: ll_a__1:
; EQ2ICMP:       # %bb.0: # %entry
; EQ2ICMP-NEXT:    movq %rsi, %rax
; EQ2ICMP-NEXT:    testq %rdi, %rdi
; EQ2ICMP-NEXT:    js .LBB6_1
; EQ2ICMP-NEXT:  # %bb.2: # %return
; EQ2ICMP-NEXT:    retq
; EQ2ICMP-NEXT:  .LBB6_1: # %if.end
; EQ2ICMP-NEXT:    cmpq $-1, %rdi
; EQ2ICMP-NEXT:    movl $1, %ecx
; EQ2ICMP-NEXT:    cmovlq %rcx, %rax
; EQ2ICMP-NEXT:    imulq %rdi, %rax
; EQ2ICMP-NEXT:    retq
entry:
  %cmp = icmp sgt i64 %a, -1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i64 %a, -1
  %mul = select i1 %cmp1, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a_0(i64 %a, i64 %b) {
; DEFAULT-LABEL: ll_a_0:
; DEFAULT:       # %bb.0: # %entry
; DEFAULT-NEXT:    testq %rdi, %rdi
; DEFAULT-NEXT:    jle .LBB7_1
; DEFAULT-NEXT:  # %bb.2: # %return
; DEFAULT-NEXT:    movq %rsi, %rax
; DEFAULT-NEXT:    retq
; DEFAULT-NEXT:  .LBB7_1: # %if.end
; DEFAULT-NEXT:    movl $1, %eax
; DEFAULT-NEXT:    cmoveq %rsi, %rax
; DEFAULT-NEXT:    imulq %rdi, %rax
; DEFAULT-NEXT:    retq
;
; EQ2ICMP-LABEL: ll_a_0:
; EQ2ICMP:       # %bb.0: # %entry
; EQ2ICMP-NEXT:    movq %rsi, %rax
; EQ2ICMP-NEXT:    testq %rdi, %rdi
; EQ2ICMP-NEXT:    jle .LBB7_1
; EQ2ICMP-NEXT:  # %bb.2: # %return
; EQ2ICMP-NEXT:    retq
; EQ2ICMP-NEXT:  .LBB7_1: # %if.end
; EQ2ICMP-NEXT:    movl $1, %ecx
; EQ2ICMP-NEXT:    cmovsq %rcx, %rax
; EQ2ICMP-NEXT:    imulq %rdi, %rax
; EQ2ICMP-NEXT:    retq
entry:
  %cmp = icmp sgt i64 %a, 0
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i64 %a, 0
  %mul = select i1 %cmp1, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a_1(i64 %a, i64 %b) {
; DEFAULT-LABEL: ll_a_1:
; DEFAULT:       # %bb.0: # %entry
; DEFAULT-NEXT:    cmpq $1, %rdi
; DEFAULT-NEXT:    jle .LBB8_1
; DEFAULT-NEXT:  # %bb.2: # %return
; DEFAULT-NEXT:    movq %rsi, %rax
; DEFAULT-NEXT:    retq
; DEFAULT-NEXT:  .LBB8_1: # %if.end
; DEFAULT-NEXT:    movl $1, %eax
; DEFAULT-NEXT:    cmoveq %rsi, %rax
; DEFAULT-NEXT:    imulq %rdi, %rax
; DEFAULT-NEXT:    retq
;
; EQ2ICMP-LABEL: ll_a_1:
; EQ2ICMP:       # %bb.0: # %entry
; EQ2ICMP-NEXT:    movq %rsi, %rax
; EQ2ICMP-NEXT:    cmpq $1, %rdi
; EQ2ICMP-NEXT:    jg .LBB8_2
; EQ2ICMP-NEXT:  # %bb.1: # %if.end
; EQ2ICMP-NEXT:    movl $1, %ecx
; EQ2ICMP-NEXT:    cmovlq %rcx, %rax
; EQ2ICMP-NEXT:    imulq %rdi, %rax
; EQ2ICMP-NEXT:  .LBB8_2: # %return
; EQ2ICMP-NEXT:    retq
entry:
  %cmp = icmp sgt i64 %a, 1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i64 %a, 1
  %mul = select i1 %cmp1, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a_2(i64 %a, i64 %b) {
; DEFAULT-LABEL: ll_a_2:
; DEFAULT:       # %bb.0: # %entry
; DEFAULT-NEXT:    cmpq $2, %rdi
; DEFAULT-NEXT:    jle .LBB9_1
; DEFAULT-NEXT:  # %bb.2: # %return
; DEFAULT-NEXT:    movq %rsi, %rax
; DEFAULT-NEXT:    retq
; DEFAULT-NEXT:  .LBB9_1: # %if.end
; DEFAULT-NEXT:    movl $1, %eax
; DEFAULT-NEXT:    cmoveq %rsi, %rax
; DEFAULT-NEXT:    imulq %rdi, %rax
; DEFAULT-NEXT:    retq
;
; EQ2ICMP-LABEL: ll_a_2:
; EQ2ICMP:       # %bb.0: # %entry
; EQ2ICMP-NEXT:    movq %rsi, %rax
; EQ2ICMP-NEXT:    cmpq $2, %rdi
; EQ2ICMP-NEXT:    jg .LBB9_2
; EQ2ICMP-NEXT:  # %bb.1: # %if.end
; EQ2ICMP-NEXT:    movl $1, %ecx
; EQ2ICMP-NEXT:    cmovlq %rcx, %rax
; EQ2ICMP-NEXT:    imulq %rdi, %rax
; EQ2ICMP-NEXT:  .LBB9_2: # %return
; EQ2ICMP-NEXT:    retq
entry:
  %cmp = icmp sgt i64 %a, 2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i64 %a, 2
  %mul = select i1 %cmp1, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @i_a_op_b__2(i32 signext %a, i32 signext %b) {
; DEFAULT-LABEL: i_a_op_b__2:
; DEFAULT:       # %bb.0: # %entry
; DEFAULT-NEXT:    movl %esi, %ecx
; DEFAULT-NEXT:    movl %edi, %eax
; DEFAULT-NEXT:    shll %cl, %eax
; DEFAULT-NEXT:    cmpl $-2, %eax
; DEFAULT-NEXT:    jg .LBB10_2
; DEFAULT-NEXT:  # %bb.1: # %if.end
; DEFAULT-NEXT:    movl $1, %eax
; DEFAULT-NEXT:    cmovel %ecx, %eax
; DEFAULT-NEXT:    imull %edi, %eax
; DEFAULT-NEXT:    movl %eax, %ecx
; DEFAULT-NEXT:  .LBB10_2: # %return
; DEFAULT-NEXT:    movslq %ecx, %rax
; DEFAULT-NEXT:    retq
;
; EQ2ICMP-LABEL: i_a_op_b__2:
; EQ2ICMP:       # %bb.0: # %entry
; EQ2ICMP-NEXT:    movl %esi, %ecx
; EQ2ICMP-NEXT:    movl %edi, %eax
; EQ2ICMP-NEXT:    shll %cl, %eax
; EQ2ICMP-NEXT:    cmpl $-2, %eax
; EQ2ICMP-NEXT:    jg .LBB10_2
; EQ2ICMP-NEXT:  # %bb.1: # %if.end
; EQ2ICMP-NEXT:    movl $1, %eax
; EQ2ICMP-NEXT:    cmovll %eax, %ecx
; EQ2ICMP-NEXT:    imull %edi, %ecx
; EQ2ICMP-NEXT:  .LBB10_2: # %return
; EQ2ICMP-NEXT:    movslq %ecx, %rax
; EQ2ICMP-NEXT:    retq
entry:
  %shl = shl i32 %a, %b
  %cmp = icmp sgt i32 %shl, -2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i32 %shl, -2
  %mul = select i1 %cmp2, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a_op_b__1(i32 signext %a, i32 signext %b) {
; DEFAULT-LABEL: i_a_op_b__1:
; DEFAULT:       # %bb.0: # %entry
; DEFAULT-NEXT:    movl %esi, %ecx
; DEFAULT-NEXT:    movl %edi, %eax
; DEFAULT-NEXT:    shll %cl, %eax
; DEFAULT-NEXT:    testl %eax, %eax
; DEFAULT-NEXT:    js .LBB11_1
; DEFAULT-NEXT:  # %bb.2: # %return
; DEFAULT-NEXT:    movslq %ecx, %rax
; DEFAULT-NEXT:    retq
; DEFAULT-NEXT:  .LBB11_1: # %if.end
; DEFAULT-NEXT:    cmpl $-1, %eax
; DEFAULT-NEXT:    movl $1, %eax
; DEFAULT-NEXT:    cmovel %ecx, %eax
; DEFAULT-NEXT:    imull %edi, %eax
; DEFAULT-NEXT:    movl %eax, %ecx
; DEFAULT-NEXT:    movslq %ecx, %rax
; DEFAULT-NEXT:    retq
;
; EQ2ICMP-LABEL: i_a_op_b__1:
; EQ2ICMP:       # %bb.0: # %entry
; EQ2ICMP-NEXT:    movl %esi, %ecx
; EQ2ICMP-NEXT:    movl %edi, %eax
; EQ2ICMP-NEXT:    shll %cl, %eax
; EQ2ICMP-NEXT:    testl %eax, %eax
; EQ2ICMP-NEXT:    js .LBB11_1
; EQ2ICMP-NEXT:  # %bb.2: # %return
; EQ2ICMP-NEXT:    movslq %ecx, %rax
; EQ2ICMP-NEXT:    retq
; EQ2ICMP-NEXT:  .LBB11_1: # %if.end
; EQ2ICMP-NEXT:    cmpl $-1, %eax
; EQ2ICMP-NEXT:    movl $1, %eax
; EQ2ICMP-NEXT:    cmovll %eax, %ecx
; EQ2ICMP-NEXT:    imull %edi, %ecx
; EQ2ICMP-NEXT:    movslq %ecx, %rax
; EQ2ICMP-NEXT:    retq
entry:
  %shl = shl i32 %a, %b
  %cmp = icmp sgt i32 %shl, -1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i32 %shl, -1
  %mul = select i1 %cmp2, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a_op_b_0(i32 signext %a, i32 signext %b) {
; DEFAULT-LABEL: i_a_op_b_0:
; DEFAULT:       # %bb.0: # %entry
; DEFAULT-NEXT:    movl %esi, %ecx
; DEFAULT-NEXT:    movl %edi, %eax
; DEFAULT-NEXT:    shll %cl, %eax
; DEFAULT-NEXT:    testl %eax, %eax
; DEFAULT-NEXT:    jle .LBB12_1
; DEFAULT-NEXT:  # %bb.2: # %return
; DEFAULT-NEXT:    movslq %ecx, %rax
; DEFAULT-NEXT:    retq
; DEFAULT-NEXT:  .LBB12_1: # %if.end
; DEFAULT-NEXT:    movl $1, %eax
; DEFAULT-NEXT:    cmovel %ecx, %eax
; DEFAULT-NEXT:    imull %edi, %eax
; DEFAULT-NEXT:    movl %eax, %ecx
; DEFAULT-NEXT:    movslq %ecx, %rax
; DEFAULT-NEXT:    retq
;
; EQ2ICMP-LABEL: i_a_op_b_0:
; EQ2ICMP:       # %bb.0: # %entry
; EQ2ICMP-NEXT:    movl %esi, %ecx
; EQ2ICMP-NEXT:    movl %edi, %eax
; EQ2ICMP-NEXT:    shll %cl, %eax
; EQ2ICMP-NEXT:    testl %eax, %eax
; EQ2ICMP-NEXT:    jle .LBB12_1
; EQ2ICMP-NEXT:  # %bb.2: # %return
; EQ2ICMP-NEXT:    movslq %ecx, %rax
; EQ2ICMP-NEXT:    retq
; EQ2ICMP-NEXT:  .LBB12_1: # %if.end
; EQ2ICMP-NEXT:    movl $1, %eax
; EQ2ICMP-NEXT:    cmovsl %eax, %ecx
; EQ2ICMP-NEXT:    imull %edi, %ecx
; EQ2ICMP-NEXT:    movslq %ecx, %rax
; EQ2ICMP-NEXT:    retq
entry:
  %shl = shl i32 %a, %b
  %cmp = icmp sgt i32 %shl, 0
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i32 %shl, 0
  %mul = select i1 %cmp2, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a_op_b_1(i32 signext %a, i32 signext %b) {
; DEFAULT-LABEL: i_a_op_b_1:
; DEFAULT:       # %bb.0: # %entry
; DEFAULT-NEXT:    movl %esi, %ecx
; DEFAULT-NEXT:    movl %edi, %eax
; DEFAULT-NEXT:    shll %cl, %eax
; DEFAULT-NEXT:    cmpl $1, %eax
; DEFAULT-NEXT:    jg .LBB13_2
; DEFAULT-NEXT:  # %bb.1: # %if.end
; DEFAULT-NEXT:    movl $1, %eax
; DEFAULT-NEXT:    cmovel %ecx, %eax
; DEFAULT-NEXT:    imull %edi, %eax
; DEFAULT-NEXT:    movl %eax, %ecx
; DEFAULT-NEXT:  .LBB13_2: # %return
; DEFAULT-NEXT:    movslq %ecx, %rax
; DEFAULT-NEXT:    retq
;
; EQ2ICMP-LABEL: i_a_op_b_1:
; EQ2ICMP:       # %bb.0: # %entry
; EQ2ICMP-NEXT:    movl %esi, %ecx
; EQ2ICMP-NEXT:    movl %edi, %eax
; EQ2ICMP-NEXT:    shll %cl, %eax
; EQ2ICMP-NEXT:    cmpl $1, %eax
; EQ2ICMP-NEXT:    jg .LBB13_2
; EQ2ICMP-NEXT:  # %bb.1: # %if.end
; EQ2ICMP-NEXT:    movl $1, %eax
; EQ2ICMP-NEXT:    cmovll %eax, %ecx
; EQ2ICMP-NEXT:    imull %edi, %ecx
; EQ2ICMP-NEXT:  .LBB13_2: # %return
; EQ2ICMP-NEXT:    movslq %ecx, %rax
; EQ2ICMP-NEXT:    retq
entry:
  %shl = shl i32 %a, %b
  %cmp = icmp sgt i32 %shl, 1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i32 %shl, 1
  %mul = select i1 %cmp2, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a_op_b_2(i32 signext %a, i32 signext %b) {
; DEFAULT-LABEL: i_a_op_b_2:
; DEFAULT:       # %bb.0: # %entry
; DEFAULT-NEXT:    movl %esi, %ecx
; DEFAULT-NEXT:    movl %edi, %eax
; DEFAULT-NEXT:    shll %cl, %eax
; DEFAULT-NEXT:    cmpl $2, %eax
; DEFAULT-NEXT:    jg .LBB14_2
; DEFAULT-NEXT:  # %bb.1: # %if.end
; DEFAULT-NEXT:    movl $1, %eax
; DEFAULT-NEXT:    cmovel %ecx, %eax
; DEFAULT-NEXT:    imull %edi, %eax
; DEFAULT-NEXT:    movl %eax, %ecx
; DEFAULT-NEXT:  .LBB14_2: # %return
; DEFAULT-NEXT:    movslq %ecx, %rax
; DEFAULT-NEXT:    retq
;
; EQ2ICMP-LABEL: i_a_op_b_2:
; EQ2ICMP:       # %bb.0: # %entry
; EQ2ICMP-NEXT:    movl %esi, %ecx
; EQ2ICMP-NEXT:    movl %edi, %eax
; EQ2ICMP-NEXT:    shll %cl, %eax
; EQ2ICMP-NEXT:    cmpl $2, %eax
; EQ2ICMP-NEXT:    jg .LBB14_2
; EQ2ICMP-NEXT:  # %bb.1: # %if.end
; EQ2ICMP-NEXT:    movl $1, %eax
; EQ2ICMP-NEXT:    cmovll %eax, %ecx
; EQ2ICMP-NEXT:    imull %edi, %ecx
; EQ2ICMP-NEXT:  .LBB14_2: # %return
; EQ2ICMP-NEXT:    movslq %ecx, %rax
; EQ2ICMP-NEXT:    retq
entry:
  %shl = shl i32 %a, %b
  %cmp = icmp sgt i32 %shl, 2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i32 %shl, 2
  %mul = select i1 %cmp2, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a__2(i32 signext %a, i32 signext %b) {
; DEFAULT-LABEL: i_a__2:
; DEFAULT:       # %bb.0: # %entry
; DEFAULT-NEXT:    cmpl $-2, %edi
; DEFAULT-NEXT:    jg .LBB15_2
; DEFAULT-NEXT:  # %bb.1: # %if.end
; DEFAULT-NEXT:    movl $1, %eax
; DEFAULT-NEXT:    cmovel %esi, %eax
; DEFAULT-NEXT:    imull %edi, %eax
; DEFAULT-NEXT:    movl %eax, %esi
; DEFAULT-NEXT:  .LBB15_2: # %return
; DEFAULT-NEXT:    movslq %esi, %rax
; DEFAULT-NEXT:    retq
;
; EQ2ICMP-LABEL: i_a__2:
; EQ2ICMP:       # %bb.0: # %entry
; EQ2ICMP-NEXT:    cmpl $-2, %edi
; EQ2ICMP-NEXT:    jg .LBB15_2
; EQ2ICMP-NEXT:  # %bb.1: # %if.end
; EQ2ICMP-NEXT:    movl $1, %eax
; EQ2ICMP-NEXT:    cmovll %eax, %esi
; EQ2ICMP-NEXT:    imull %edi, %esi
; EQ2ICMP-NEXT:  .LBB15_2: # %return
; EQ2ICMP-NEXT:    movslq %esi, %rax
; EQ2ICMP-NEXT:    retq
entry:
  %cmp = icmp sgt i32 %a, -2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i32 %a, -2
  %mul = select i1 %cmp1, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a__1(i32 signext %a, i32 signext %b) {
; DEFAULT-LABEL: i_a__1:
; DEFAULT:       # %bb.0: # %entry
; DEFAULT-NEXT:    testl %edi, %edi
; DEFAULT-NEXT:    js .LBB16_1
; DEFAULT-NEXT:  # %bb.2: # %return
; DEFAULT-NEXT:    movslq %esi, %rax
; DEFAULT-NEXT:    retq
; DEFAULT-NEXT:  .LBB16_1: # %if.end
; DEFAULT-NEXT:    cmpl $-1, %edi
; DEFAULT-NEXT:    movl $1, %eax
; DEFAULT-NEXT:    cmovel %esi, %eax
; DEFAULT-NEXT:    imull %edi, %eax
; DEFAULT-NEXT:    movl %eax, %esi
; DEFAULT-NEXT:    movslq %esi, %rax
; DEFAULT-NEXT:    retq
;
; EQ2ICMP-LABEL: i_a__1:
; EQ2ICMP:       # %bb.0: # %entry
; EQ2ICMP-NEXT:    testl %edi, %edi
; EQ2ICMP-NEXT:    js .LBB16_1
; EQ2ICMP-NEXT:  # %bb.2: # %return
; EQ2ICMP-NEXT:    movslq %esi, %rax
; EQ2ICMP-NEXT:    retq
; EQ2ICMP-NEXT:  .LBB16_1: # %if.end
; EQ2ICMP-NEXT:    cmpl $-1, %edi
; EQ2ICMP-NEXT:    movl $1, %eax
; EQ2ICMP-NEXT:    cmovll %eax, %esi
; EQ2ICMP-NEXT:    imull %edi, %esi
; EQ2ICMP-NEXT:    movslq %esi, %rax
; EQ2ICMP-NEXT:    retq
entry:
  %cmp = icmp sgt i32 %a, -1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i32 %a, -1
  %mul = select i1 %cmp1, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a_0(i32 signext %a, i32 signext %b) {
; DEFAULT-LABEL: i_a_0:
; DEFAULT:       # %bb.0: # %entry
; DEFAULT-NEXT:    testl %edi, %edi
; DEFAULT-NEXT:    jle .LBB17_1
; DEFAULT-NEXT:  # %bb.2: # %return
; DEFAULT-NEXT:    movslq %esi, %rax
; DEFAULT-NEXT:    retq
; DEFAULT-NEXT:  .LBB17_1: # %if.end
; DEFAULT-NEXT:    movl $1, %eax
; DEFAULT-NEXT:    cmovel %esi, %eax
; DEFAULT-NEXT:    imull %edi, %eax
; DEFAULT-NEXT:    movl %eax, %esi
; DEFAULT-NEXT:    movslq %esi, %rax
; DEFAULT-NEXT:    retq
;
; EQ2ICMP-LABEL: i_a_0:
; EQ2ICMP:       # %bb.0: # %entry
; EQ2ICMP-NEXT:    testl %edi, %edi
; EQ2ICMP-NEXT:    jle .LBB17_1
; EQ2ICMP-NEXT:  # %bb.2: # %return
; EQ2ICMP-NEXT:    movslq %esi, %rax
; EQ2ICMP-NEXT:    retq
; EQ2ICMP-NEXT:  .LBB17_1: # %if.end
; EQ2ICMP-NEXT:    movl $1, %eax
; EQ2ICMP-NEXT:    cmovsl %eax, %esi
; EQ2ICMP-NEXT:    imull %edi, %esi
; EQ2ICMP-NEXT:    movslq %esi, %rax
; EQ2ICMP-NEXT:    retq
entry:
  %cmp = icmp sgt i32 %a, 0
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i32 %a, 0
  %mul = select i1 %cmp1, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a_1(i32 signext %a, i32 signext %b) {
; DEFAULT-LABEL: i_a_1:
; DEFAULT:       # %bb.0: # %entry
; DEFAULT-NEXT:    cmpl $1, %edi
; DEFAULT-NEXT:    jg .LBB18_2
; DEFAULT-NEXT:  # %bb.1: # %if.end
; DEFAULT-NEXT:    movl $1, %eax
; DEFAULT-NEXT:    cmovel %esi, %eax
; DEFAULT-NEXT:    imull %edi, %eax
; DEFAULT-NEXT:    movl %eax, %esi
; DEFAULT-NEXT:  .LBB18_2: # %return
; DEFAULT-NEXT:    movslq %esi, %rax
; DEFAULT-NEXT:    retq
;
; EQ2ICMP-LABEL: i_a_1:
; EQ2ICMP:       # %bb.0: # %entry
; EQ2ICMP-NEXT:    cmpl $1, %edi
; EQ2ICMP-NEXT:    jg .LBB18_2
; EQ2ICMP-NEXT:  # %bb.1: # %if.end
; EQ2ICMP-NEXT:    movl $1, %eax
; EQ2ICMP-NEXT:    cmovll %eax, %esi
; EQ2ICMP-NEXT:    imull %edi, %esi
; EQ2ICMP-NEXT:  .LBB18_2: # %return
; EQ2ICMP-NEXT:    movslq %esi, %rax
; EQ2ICMP-NEXT:    retq
entry:
  %cmp = icmp sgt i32 %a, 1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i32 %a, 1
  %mul = select i1 %cmp1, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a_2(i32 signext %a, i32 signext %b) {
; DEFAULT-LABEL: i_a_2:
; DEFAULT:       # %bb.0: # %entry
; DEFAULT-NEXT:    cmpl $2, %edi
; DEFAULT-NEXT:    jg .LBB19_2
; DEFAULT-NEXT:  # %bb.1: # %if.end
; DEFAULT-NEXT:    movl $1, %eax
; DEFAULT-NEXT:    cmovel %esi, %eax
; DEFAULT-NEXT:    imull %edi, %eax
; DEFAULT-NEXT:    movl %eax, %esi
; DEFAULT-NEXT:  .LBB19_2: # %return
; DEFAULT-NEXT:    movslq %esi, %rax
; DEFAULT-NEXT:    retq
;
; EQ2ICMP-LABEL: i_a_2:
; EQ2ICMP:       # %bb.0: # %entry
; EQ2ICMP-NEXT:    cmpl $2, %edi
; EQ2ICMP-NEXT:    jg .LBB19_2
; EQ2ICMP-NEXT:  # %bb.1: # %if.end
; EQ2ICMP-NEXT:    movl $1, %eax
; EQ2ICMP-NEXT:    cmovll %eax, %esi
; EQ2ICMP-NEXT:    imull %edi, %esi
; EQ2ICMP-NEXT:  .LBB19_2: # %return
; EQ2ICMP-NEXT:    movslq %esi, %rax
; EQ2ICMP-NEXT:    retq
entry:
  %cmp = icmp sgt i32 %a, 2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i32 %a, 2
  %mul = select i1 %cmp1, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}
