; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown | FileCheck %s --check-prefix=X64
; RUN: llc < %s -mtriple=i686-unknown-unknown | FileCheck %s --check-prefix=X86

; shift left

define i32 @and_signbit_select_shl(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: and_signbit_select_shl:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $16711680, %eax # imm = 0xFF0000
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    shll $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: and_signbit_select_shl:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    testb $1, {{[0-9]+}}(%esp)
; X86-NEXT:    je .LBB0_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    andl $16711680, %eax # imm = 0xFF0000
; X86-NEXT:  .LBB0_2:
; X86-NEXT:    shll $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = and i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @and_nosignbit_select_shl(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: and_nosignbit_select_shl:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $16711680, %eax # imm = 0xFF0000
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    shll $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: and_nosignbit_select_shl:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    testb $1, {{[0-9]+}}(%esp)
; X86-NEXT:    je .LBB1_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    andl $16711680, %eax # imm = 0xFF0000
; X86-NEXT:  .LBB1_2:
; X86-NEXT:    shll $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = and i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @or_signbit_select_shl(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: or_signbit_select_shl:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    orl $16711680, %eax # imm = 0xFF0000
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    shll $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: or_signbit_select_shl:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    andl $16711680, %eax # imm = 0xFF0000
; X86-NEXT:    orl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shll $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = or i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @or_nosignbit_select_shl(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: or_nosignbit_select_shl:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    orl $16711680, %eax # imm = 0xFF0000
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    shll $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: or_nosignbit_select_shl:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    andl $16711680, %eax # imm = 0xFF0000
; X86-NEXT:    orl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shll $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = or i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @xor_signbit_select_shl(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: xor_signbit_select_shl:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    xorl $16711680, %eax # imm = 0xFF0000
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    shll $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: xor_signbit_select_shl:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    andl $16711680, %eax # imm = 0xFF0000
; X86-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shll $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = xor i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @xor_nosignbit_select_shl(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: xor_nosignbit_select_shl:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    xorl $16711680, %eax # imm = 0xFF0000
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    shll $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: xor_nosignbit_select_shl:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    andl $16711680, %eax # imm = 0xFF0000
; X86-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shll $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = xor i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @add_signbit_select_shl(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: add_signbit_select_shl:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal -65536(%rdi), %eax
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    shll $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: add_signbit_select_shl:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    andl $16711680, %eax # imm = 0xFF0000
; X86-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shll $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = add i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @add_nosignbit_select_shl(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: add_nosignbit_select_shl:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal 2147418112(%rdi), %eax
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    shll $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: add_nosignbit_select_shl:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    andl $16711680, %eax # imm = 0xFF0000
; X86-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shll $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = add i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

; logical shift right

define i32 @and_signbit_select_lshr(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: and_signbit_select_lshr:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $-65536, %eax # imm = 0xFFFF0000
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    shrl $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: and_signbit_select_lshr:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    testb $1, {{[0-9]+}}(%esp)
; X86-NEXT:    je .LBB8_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    andl $-65536, %eax # imm = 0xFFFF0000
; X86-NEXT:  .LBB8_2:
; X86-NEXT:    shrl $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = and i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @and_nosignbit_select_lshr(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: and_nosignbit_select_lshr:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $2147418112, %eax # imm = 0x7FFF0000
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    shrl $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: and_nosignbit_select_lshr:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    testb $1, {{[0-9]+}}(%esp)
; X86-NEXT:    je .LBB9_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    andl $2147418112, %eax # imm = 0x7FFF0000
; X86-NEXT:  .LBB9_2:
; X86-NEXT:    shrl $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = and i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @or_signbit_select_lshr(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: or_signbit_select_lshr:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    orl $-65536, %eax # imm = 0xFFFF0000
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    shrl $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: or_signbit_select_lshr:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    andl $-65536, %eax # imm = 0xFFFF0000
; X86-NEXT:    orl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shrl $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = or i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @or_nosignbit_select_lshr(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: or_nosignbit_select_lshr:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    orl $2147418112, %eax # imm = 0x7FFF0000
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    shrl $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: or_nosignbit_select_lshr:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    andl $2147418112, %eax # imm = 0x7FFF0000
; X86-NEXT:    orl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shrl $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = or i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @xor_signbit_select_lshr(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: xor_signbit_select_lshr:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    xorl $-65536, %eax # imm = 0xFFFF0000
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    shrl $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: xor_signbit_select_lshr:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    andl $-65536, %eax # imm = 0xFFFF0000
; X86-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shrl $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = xor i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @xor_nosignbit_select_lshr(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: xor_nosignbit_select_lshr:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    xorl $2147418112, %eax # imm = 0x7FFF0000
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    shrl $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: xor_nosignbit_select_lshr:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    andl $2147418112, %eax # imm = 0x7FFF0000
; X86-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shrl $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = xor i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @add_signbit_select_lshr(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: add_signbit_select_lshr:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal -65536(%rdi), %eax
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    shrl $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: add_signbit_select_lshr:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    andl $-65536, %eax # imm = 0xFFFF0000
; X86-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shrl $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = add i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @add_nosignbit_select_lshr(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: add_nosignbit_select_lshr:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal 2147418112(%rdi), %eax
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    shrl $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: add_nosignbit_select_lshr:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    andl $2147418112, %eax # imm = 0x7FFF0000
; X86-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    shrl $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = add i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

; arithmetic shift right

define i32 @and_signbit_select_ashr(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: and_signbit_select_ashr:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $-65536, %eax # imm = 0xFFFF0000
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    sarl $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: and_signbit_select_ashr:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    testb $1, {{[0-9]+}}(%esp)
; X86-NEXT:    je .LBB16_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    andl $-65536, %eax # imm = 0xFFFF0000
; X86-NEXT:  .LBB16_2:
; X86-NEXT:    sarl $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = and i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @and_nosignbit_select_ashr(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: and_nosignbit_select_ashr:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $2147418112, %eax # imm = 0x7FFF0000
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    sarl $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: and_nosignbit_select_ashr:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    testb $1, {{[0-9]+}}(%esp)
; X86-NEXT:    je .LBB17_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    andl $2147418112, %eax # imm = 0x7FFF0000
; X86-NEXT:  .LBB17_2:
; X86-NEXT:    sarl $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = and i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @or_signbit_select_ashr(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: or_signbit_select_ashr:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    orl $-65536, %eax # imm = 0xFFFF0000
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    sarl $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: or_signbit_select_ashr:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    andl $-65536, %eax # imm = 0xFFFF0000
; X86-NEXT:    orl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    sarl $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = or i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @or_nosignbit_select_ashr(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: or_nosignbit_select_ashr:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    orl $2147418112, %eax # imm = 0x7FFF0000
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    sarl $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: or_nosignbit_select_ashr:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    andl $2147418112, %eax # imm = 0x7FFF0000
; X86-NEXT:    orl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    sarl $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = or i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @xor_signbit_select_ashr(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: xor_signbit_select_ashr:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    xorl $-65536, %eax # imm = 0xFFFF0000
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    sarl $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: xor_signbit_select_ashr:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    andl $-65536, %eax # imm = 0xFFFF0000
; X86-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    sarl $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = xor i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @xor_nosignbit_select_ashr(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: xor_nosignbit_select_ashr:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    xorl $2147418112, %eax # imm = 0x7FFF0000
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    sarl $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: xor_nosignbit_select_ashr:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    andl $2147418112, %eax # imm = 0x7FFF0000
; X86-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    sarl $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = xor i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @add_signbit_select_ashr(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: add_signbit_select_ashr:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal -65536(%rdi), %eax
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    sarl $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: add_signbit_select_ashr:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    andl $-65536, %eax # imm = 0xFFFF0000
; X86-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    sarl $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = add i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @add_nosignbit_select_ashr(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: add_nosignbit_select_ashr:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    leal 2147418112(%rdi), %eax
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    sarl $8, %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: add_nosignbit_select_ashr:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    andl $2147418112, %eax # imm = 0x7FFF0000
; X86-NEXT:    addl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    sarl $8, %eax
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = add i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @shl_signbit_select_add(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: shl_signbit_select_add:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shll $4, %eax
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    addl $123456, %eax # imm = 0x1E240
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: shl_signbit_select_add:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    andb $1, %cl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    negb %cl
; X86-NEXT:    andb $4, %cl
; X86-NEXT:    shll %cl, %eax
; X86-NEXT:    addl $123456, %eax # imm = 0x1E240
; X86-NEXT:    movl %eax, (%edx)
; X86-NEXT:    retl
  %t0 = shl i32 %x, 4
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = add i32 %t1, 123456
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @shl_signbit_select_add_fail(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: shl_signbit_select_add_fail:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shll $4, %eax
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovnel %edi, %eax
; X64-NEXT:    addl $123456, %eax # imm = 0x1E240
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: shl_signbit_select_add_fail:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    testb $1, {{[0-9]+}}(%esp)
; X86-NEXT:    jne .LBB25_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    shll $4, %eax
; X86-NEXT:  .LBB25_2:
; X86-NEXT:    addl $123456, %eax # imm = 0x1E240
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = shl i32 %x, 4
  %t1 = select i1 %cond, i32 %x, i32 %t0
  %r = add i32 %t1, 123456
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @lshr_signbit_select_add(i32 %x, i1 %cond, ptr %dst, i32 %y) {
; X64-LABEL: lshr_signbit_select_add:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NEXT:    shrl %cl, %eax
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    addl $123456, %eax # imm = 0x1E240
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: lshr_signbit_select_add:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    andb $1, %cl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    negb %cl
; X86-NEXT:    andb {{[0-9]+}}(%esp), %cl
; X86-NEXT:    shrl %cl, %eax
; X86-NEXT:    addl $123456, %eax # imm = 0x1E240
; X86-NEXT:    movl %eax, (%edx)
; X86-NEXT:    retl
  %t0 = lshr i32 %x, %y
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = add i32 %t1, 123456
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @ashr_signbit_select_add(i32 %x, i1 %cond, ptr %dst) {
; X64-LABEL: ashr_signbit_select_add:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    sarl $4, %eax
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %eax
; X64-NEXT:    addl $123456, %eax # imm = 0x1E240
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: ashr_signbit_select_add:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    andb $1, %cl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    negb %cl
; X86-NEXT:    andb $4, %cl
; X86-NEXT:    sarl %cl, %eax
; X86-NEXT:    addl $123456, %eax # imm = 0x1E240
; X86-NEXT:    movl %eax, (%edx)
; X86-NEXT:    retl
  %t0 = ashr i32 %x, 4
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = add i32 %t1, 123456
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @and_signbit_select_add(i32 %x, i1 %cond, ptr %dst, i32 %y) {
; X64-LABEL: and_signbit_select_add:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $ecx killed $ecx def $rcx
; X64-NEXT:    andl %edi, %ecx
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovnel %edi, %ecx
; X64-NEXT:    leal 123456(%rcx), %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: and_signbit_select_add:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl $1, %eax
; X86-NEXT:    negl %eax
; X86-NEXT:    orl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    addl $123456, %eax # imm = 0x1E240
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = and i32 %x, %y
  %t1 = select i1 %cond, i32 %x, i32 %t0
  %r = add i32 %t1, 123456
  store i32 %r, ptr %dst
  ret i32 %r
}


define i32 @and_signbit_select_add_fail(i32 %x, i1 %cond, ptr %dst, i32 %y) {
; X64-LABEL: and_signbit_select_add_fail:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $ecx killed $ecx def $rcx
; X64-NEXT:    andl %edi, %ecx
; X64-NEXT:    testb $1, %sil
; X64-NEXT:    cmovel %edi, %ecx
; X64-NEXT:    leal 123456(%rcx), %eax
; X64-NEXT:    movl %eax, (%rdx)
; X64-NEXT:    retq
;
; X86-LABEL: and_signbit_select_add_fail:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    testb $1, {{[0-9]+}}(%esp)
; X86-NEXT:    je .LBB29_2
; X86-NEXT:  # %bb.1:
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:  .LBB29_2:
; X86-NEXT:    addl $123456, %eax # imm = 0x1E240
; X86-NEXT:    movl %eax, (%ecx)
; X86-NEXT:    retl
  %t0 = and i32 %x, %y
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = add i32 %t1, 123456
  store i32 %r, ptr %dst
  ret i32 %r
}

