; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -fast-isel -mtriple=i386-unknown-unknown -mattr=+avx,+f16c | FileCheck %s --check-prefixes=CHECK,X86
; RUN: llc < %s -fast-isel -mtriple=x86_64-unknown-unknown -mattr=+avx,+f16c | FileCheck %s --check-prefixes=CHECK,X64

; NOTE: This should use IR equivalent to what is generated by clang/test/CodeGen/f16c-builtins.c

define float @test_cvtsh_ss(i16 %a0) nounwind {
; X86-LABEL: test_cvtsh_ss:
; X86:       # %bb.0:
; X86-NEXT:    pushl %eax
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    vmovd %eax, %xmm0
; X86-NEXT:    vcvtph2ps %xmm0, %xmm0
; X86-NEXT:    vmovss %xmm0, (%esp)
; X86-NEXT:    flds (%esp)
; X86-NEXT:    popl %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_cvtsh_ss:
; X64:       # %bb.0:
; X64-NEXT:    vmovd %edi, %xmm0
; X64-NEXT:    vcvtph2ps %xmm0, %xmm0
; X64-NEXT:    retq
  %ins0 = insertelement <8 x i16> undef, i16 %a0, i32 0
  %ins1 = insertelement <8 x i16> %ins0, i16 0, i32 1
  %ins2 = insertelement <8 x i16> %ins1, i16 0, i32 2
  %ins3 = insertelement <8 x i16> %ins2, i16 0, i32 3
  %ins4 = insertelement <8 x i16> %ins3, i16 0, i32 4
  %ins5 = insertelement <8 x i16> %ins4, i16 0, i32 5
  %ins6 = insertelement <8 x i16> %ins5, i16 0, i32 6
  %ins7 = insertelement <8 x i16> %ins6, i16 0, i32 7
  %shuffle = shufflevector <8 x i16> %ins7, <8 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %bc = bitcast <4 x i16> %shuffle to <4 x half>
  %cvt = fpext <4 x half> %bc to <4 x float>
  %res = extractelement <4 x float> %cvt, i32 0
  ret float %res
}

define i16 @test_cvtss_sh(float %a0) nounwind {
; X86-LABEL: test_cvtss_sh:
; X86:       # %bb.0:
; X86-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86-NEXT:    vcvtps2ph $0, %xmm0, %xmm0
; X86-NEXT:    vmovd %xmm0, %eax
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: test_cvtss_sh:
; X64:       # %bb.0:
; X64-NEXT:    vcvtps2ph $0, %xmm0, %xmm0
; X64-NEXT:    vmovd %xmm0, %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %ins0 = insertelement <4 x float> undef, float %a0, i32 0
  %ins1 = insertelement <4 x float> %ins0, float 0.000000e+00, i32 1
  %ins2 = insertelement <4 x float> %ins1, float 0.000000e+00, i32 2
  %ins3 = insertelement <4 x float> %ins2, float 0.000000e+00, i32 3
  %cvt = call <8 x i16> @llvm.x86.vcvtps2ph.128(<4 x float> %ins3, i32 0)
  %res = extractelement <8 x i16> %cvt, i32 0
  ret i16 %res
}

define <4 x float> @test_mm_cvtph_ps(<2 x i64> %a0) nounwind {
; CHECK-LABEL: test_mm_cvtph_ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2ps %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %shuffle = shufflevector <8 x i16> %arg0, <8 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %bc = bitcast <4 x i16> %shuffle to <4 x half>
  %res = fpext <4 x half> %bc to <4 x float>
  ret <4 x float> %res
}

define <8 x float> @test_mm256_cvtph_ps(<2 x i64> %a0) nounwind {
; CHECK-LABEL: test_mm256_cvtph_ps:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtph2ps %xmm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %arg0 = bitcast <2 x i64> %a0 to <8 x i16>
  %bc = bitcast <8 x i16> %arg0 to <8 x half>
  %res = fpext <8 x half> %bc to <8 x float>
  ret <8 x float> %res
}

define <2 x i64> @test_mm_cvtps_ph(<4 x float> %a0) nounwind {
; CHECK-LABEL: test_mm_cvtps_ph:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtps2ph $0, %xmm0, %xmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %cvt = call <8 x i16> @llvm.x86.vcvtps2ph.128(<4 x float> %a0, i32 0)
  %res = bitcast <8 x i16> %cvt to <2 x i64>
  ret <2 x i64> %res
}

define <2 x i64> @test_mm256_cvtps_ph(<8 x float> %a0) nounwind {
; CHECK-LABEL: test_mm256_cvtps_ph:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvtps2ph $0, %ymm0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
  %cvt = call <8 x i16> @llvm.x86.vcvtps2ph.256(<8 x float> %a0, i32 0)
  %res = bitcast <8 x i16> %cvt to <2 x i64>
  ret <2 x i64> %res
}

declare <4 x float> @llvm.x86.vcvtph2ps.128(<8 x i16>) nounwind readonly
declare <8 x float> @llvm.x86.vcvtph2ps.256(<8 x i16>) nounwind readonly

declare <8 x i16> @llvm.x86.vcvtps2ph.128(<4 x float>, i32) nounwind readonly
declare <8 x i16> @llvm.x86.vcvtps2ph.256(<8 x float>, i32) nounwind readonly
