; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=CHECK,SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=CHECK,AVX

declare {i32, i1} @llvm.smul.with.overflow.i32(i32, i32) nounwind readnone
declare {i32, i1} @llvm.umul.with.overflow.i32(i32, i32) nounwind readnone

declare {<4 x i32>, <4 x i1>} @llvm.smul.with.overflow.v4i32(<4 x i32>, <4 x i32>) nounwind readnone
declare {<4 x i32>, <4 x i1>} @llvm.umul.with.overflow.v4i32(<4 x i32>, <4 x i32>) nounwind readnone

; fold (smulo x, 2) -> (saddo x, x)
define i32 @combine_smul_two(i32 %a0, i32 %a1) {
; CHECK-LABEL: combine_smul_two:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    addl %edi, %eax
; CHECK-NEXT:    cmovol %esi, %eax
; CHECK-NEXT:    retq
  %1 = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %a0, i32 2)
  %2 = extractvalue {i32, i1} %1, 0
  %3 = extractvalue {i32, i1} %1, 1
  %4 = select i1 %3, i32 %a1, i32 %2
  ret i32 %4
}

define <4 x i32> @combine_vec_smul_two(<4 x i32> %a0, <4 x i32> %a1) {
; SSE-LABEL: combine_vec_smul_two:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    paddd %xmm0, %xmm2
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE-NEXT:    pxor %xmm3, %xmm0
; SSE-NEXT:    blendvps %xmm0, %xmm1, %xmm2
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_vec_smul_two:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddd %xmm0, %xmm0, %xmm2
; AVX-NEXT:    vpcmpgtd %xmm2, %xmm0, %xmm3
; AVX-NEXT:    vpxor %xmm3, %xmm0, %xmm0
; AVX-NEXT:    vblendvps %xmm0, %xmm1, %xmm2, %xmm0
; AVX-NEXT:    retq
  %1 = call {<4 x i32>, <4 x i1>} @llvm.smul.with.overflow.v4i32(<4 x i32> %a0, <4 x i32> <i32 2, i32 2, i32 2, i32 2>)
  %2 = extractvalue {<4 x i32>, <4 x i1>} %1, 0
  %3 = extractvalue {<4 x i32>, <4 x i1>} %1, 1
  %4 = select <4 x i1> %3, <4 x i32> %a1, <4 x i32> %2
  ret <4 x i32> %4
}

; fold (umulo x, 2) -> (uaddo x, x)
define i32 @combine_umul_two(i32 %a0, i32 %a1) {
; CHECK-LABEL: combine_umul_two:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    addl %edi, %eax
; CHECK-NEXT:    cmovbl %esi, %eax
; CHECK-NEXT:    retq
  %1 = call {i32, i1} @llvm.umul.with.overflow.i32(i32 %a0, i32 2)
  %2 = extractvalue {i32, i1} %1, 0
  %3 = extractvalue {i32, i1} %1, 1
  %4 = select i1 %3, i32 %a1, i32 %2
  ret i32 %4
}

define <4 x i32> @combine_vec_umul_two(<4 x i32> %a0, <4 x i32> %a1) {
; SSE-LABEL: combine_vec_umul_two:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    paddd %xmm0, %xmm2
; SSE-NEXT:    pmaxud %xmm2, %xmm0
; SSE-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE-NEXT:    blendvps %xmm0, %xmm2, %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_vec_umul_two:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddd %xmm0, %xmm0, %xmm2
; AVX-NEXT:    vpmaxud %xmm0, %xmm2, %xmm0
; AVX-NEXT:    vpcmpeqd %xmm0, %xmm2, %xmm0
; AVX-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = call {<4 x i32>, <4 x i1>} @llvm.umul.with.overflow.v4i32(<4 x i32> %a0, <4 x i32> <i32 2, i32 2, i32 2, i32 2>)
  %2 = extractvalue {<4 x i32>, <4 x i1>} %1, 0
  %3 = extractvalue {<4 x i32>, <4 x i1>} %1, 1
  %4 = select <4 x i1> %3, <4 x i32> %a1, <4 x i32> %2
  ret <4 x i32> %4
}

define { i32, i1 } @combine_smul_nsw(i32 %a, i32 %b) {
; CHECK-LABEL: combine_smul_nsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl %esi, %eax
; CHECK-NEXT:    andl $4095, %edi # imm = 0xFFF
; CHECK-NEXT:    andl $524287, %eax # imm = 0x7FFFF
; CHECK-NEXT:    imull %edi, %eax
; CHECK-NEXT:    xorl %edx, %edx
; CHECK-NEXT:    retq
  %aa = and i32 %a, 4095 ; 0xfff
  %bb = and i32 %b, 524287; 0x7ffff
  %x = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 %aa, i32 %bb)
  ret { i32, i1 } %x
}

define { <4 x i32>, <4 x i1> } @combine_vec_smul_nsw(<4 x i32> %a, <4 x i32> %b) {
; SSE-LABEL: combine_vec_smul_nsw:
; SSE:       # %bb.0:
; SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm1
; SSE-NEXT:    pmulld %xmm1, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: combine_vec_smul_nsw:
; AVX:       # %bb.0:
; AVX-NEXT:    vpbroadcastd {{.*#+}} xmm2 = [4095,4095,4095,4095]
; AVX-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX-NEXT:    vpbroadcastd {{.*#+}} xmm2 = [524287,524287,524287,524287]
; AVX-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX-NEXT:    vpmulld %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX-NEXT:    retq
  %aa = and <4 x i32> %a, <i32 4095, i32 4095, i32 4095, i32 4095>
  %bb = and <4 x i32> %b, <i32 524287, i32 524287, i32 524287, i32 524287>
  %x = call { <4 x i32>, <4 x i1> } @llvm.smul.with.overflow.v4i32(<4 x i32> %aa, <4 x i32> %bb)
  ret { <4 x i32>, <4 x i1> } %x
}
