; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -wasm-keep-registers | FileCheck %s
; RUN: llc < %s -wasm-keep-registers -fast-isel -fast-isel-abort=1 | FileCheck %s --check-prefix=FAST

target triple = "wasm32-unknown-unknown"

define i32 @return_i32(i32 %p) {
; CHECK-LABEL: return_i32:
; CHECK:         .functype return_i32 (i32) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get $push0=, 0
; CHECK-NEXT:    # fallthrough-return
;
; FAST-LABEL: return_i32:
; FAST:         .functype return_i32 (i32) -> (i32)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    local.get $push0=, 0
; FAST-NEXT:    # fallthrough-return
  ret i32 %p
}

define i32 @return_i32_twice(i32 %a) {
; CHECK-LABEL: return_i32_twice:
; CHECK:         .functype return_i32_twice (i32) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    block
; CHECK-NEXT:    local.get $push6=, 0
; CHECK-NEXT:    i32.eqz $push7=, $pop6
; CHECK-NEXT:    br_if 0, $pop7 # 0: down to label0
; CHECK-NEXT:  # %bb.1: # %true
; CHECK-NEXT:    i32.const $push3=, 0
; CHECK-NEXT:    i32.const $push5=, 0
; CHECK-NEXT:    i32.store 0($pop3), $pop5
; CHECK-NEXT:    i32.const $push4=, 1
; CHECK-NEXT:    return $pop4
; CHECK-NEXT:  .LBB1_2: # %false
; CHECK-NEXT:    end_block # label0:
; CHECK-NEXT:    i32.const $push1=, 0
; CHECK-NEXT:    i32.const $push0=, 2
; CHECK-NEXT:    i32.store 0($pop1), $pop0
; CHECK-NEXT:    i32.const $push2=, 3
; CHECK-NEXT:    # fallthrough-return
;
; FAST-LABEL: return_i32_twice:
; FAST:         .functype return_i32_twice (i32) -> (i32)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    block
; FAST-NEXT:    local.get $push6=, 0
; FAST-NEXT:    i32.eqz $push7=, $pop6
; FAST-NEXT:    br_if 0, $pop7 # 0: down to label0
; FAST-NEXT:  # %bb.1: # %true
; FAST-NEXT:    i32.const $push4=, 0
; FAST-NEXT:    i32.const $push5=, 0
; FAST-NEXT:    i32.store 0($pop4), $pop5
; FAST-NEXT:    i32.const $push3=, 1
; FAST-NEXT:    return $pop3
; FAST-NEXT:  .LBB1_2: # %false
; FAST-NEXT:    end_block # label0:
; FAST-NEXT:    i32.const $push1=, 0
; FAST-NEXT:    i32.const $push2=, 2
; FAST-NEXT:    i32.store 0($pop1), $pop2
; FAST-NEXT:    i32.const $push0=, 3
; FAST-NEXT:    # fallthrough-return
  %b = icmp ne i32 %a, 0
  br i1 %b, label %true, label %false

true:
  store i32 0, ptr null
  ret i32 1

false:
  store i32 2, ptr null
  ret i32 3
}
