; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs < %s -mtriple=thumbv8.1m.main-none-eabi | FileCheck %s

define i32 @ori32i32_eq(i32 %x, i32 %y) {
; CHECK-LABEL: ori32i32_eq:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    and r0, r0, #1
; CHECK-NEXT:    cmp r1, #0
; CHECK-NEXT:    csinc r0, r0, zr, ne
; CHECK-NEXT:    bx lr
  %xa = and i32 %x, 1
  %c = icmp eq i32 %y, 0
  %cz = zext i1 %c to i32
  %a = or i32 %xa, %cz
  ret i32 %a
}

define i32 @ori32_eq_c(i32 %x, i32 %y) {
; CHECK-LABEL: ori32_eq_c:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    and r0, r0, #1
; CHECK-NEXT:    cmp r1, #0
; CHECK-NEXT:    csinc r0, r0, zr, ne
; CHECK-NEXT:    bx lr
  %xa = and i32 %x, 1
  %c = icmp eq i32 %y, 0
  %cz = zext i1 %c to i32
  %a = or i32 %cz, %xa
  ret i32 %a
}

define i32 @ori32i64_eq(i32 %x, i64 %y) {
; CHECK-LABEL: ori32i64_eq:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    orrs.w r1, r2, r3
; CHECK-NEXT:    and r0, r0, #1
; CHECK-NEXT:    csinc r0, r0, zr, ne
; CHECK-NEXT:    bx lr
  %xa = and i32 %x, 1
  %c = icmp eq i64 %y, 0
  %cz = zext i1 %c to i32
  %a = or i32 %xa, %cz
  ret i32 %a
}

define i32 @ori32_sgt(i32 %x, i32 %y) {
; CHECK-LABEL: ori32_sgt:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    and r0, r0, #1
; CHECK-NEXT:    cmp r1, #0
; CHECK-NEXT:    csinc r0, r0, zr, le
; CHECK-NEXT:    bx lr
  %xa = and i32 %x, 1
  %c = icmp sgt i32 %y, 0
  %cz = zext i1 %c to i32
  %a = or i32 %xa, %cz
  ret i32 %a
}

; Negative test - too many demanded bits
define i32 @ori32_toomanybits(i32 %x, i32 %y) {
; CHECK-LABEL: ori32_toomanybits:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    and r0, r0, #3
; CHECK-NEXT:    cmp r1, #0
; CHECK-NEXT:    it eq
; CHECK-NEXT:    orreq r0, r0, #1
; CHECK-NEXT:    bx lr
  %xa = and i32 %x, 3
  %c = icmp eq i32 %y, 0
  %cz = zext i1 %c to i32
  %a = or i32 %xa, %cz
  ret i32 %a
}

define i32 @andi32_ne(i8 %x, i8 %y) {
; CHECK-LABEL: andi32_ne:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    tst.w r0, #255
; CHECK-NEXT:    cset r0, eq
; CHECK-NEXT:    tst.w r1, #255
; CHECK-NEXT:    csel r0, zr, r0, eq
; CHECK-NEXT:    bx lr
  %xc = icmp eq i8 %x, 0
  %xa = zext i1 %xc to i32
  %c = icmp ne i8 %y, 0
  %cz = zext i1 %c to i32
  %a = and i32 %xa, %cz
  ret i32 %a
}

define i32 @andi32_sgt(i8 %x, i8 %y) {
; CHECK-LABEL: andi32_sgt:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    tst.w r0, #255
; CHECK-NEXT:    sxtb r1, r1
; CHECK-NEXT:    cset r0, eq
; CHECK-NEXT:    cmp r1, #0
; CHECK-NEXT:    csel r0, zr, r0, le
; CHECK-NEXT:    bx lr
  %xc = icmp eq i8 %x, 0
  %xa = zext i1 %xc to i32
  %c = icmp sgt i8 %y, 0
  %cz = zext i1 %c to i32
  %a = and i32 %xa, %cz
  ret i32 %a
}

define i64 @ori64i32_eq(i64 %x, i32 %y) {
; CHECK-LABEL: ori64i32_eq:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    and r0, r0, #1
; CHECK-NEXT:    cset r1, eq
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    movs r1, #0
; CHECK-NEXT:    bx lr
  %xa = and i64 %x, 1
  %c = icmp eq i32 %y, 0
  %cz = zext i1 %c to i64
  %a = or i64 %xa, %cz
  ret i64 %a
}

define i64 @ori64i64_eq(i64 %x, i64 %y) {
; CHECK-LABEL: ori64i64_eq:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    orrs.w r1, r2, r3
; CHECK-NEXT:    and r0, r0, #1
; CHECK-NEXT:    cset r1, eq
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    movs r1, #0
; CHECK-NEXT:    bx lr
  %xa = and i64 %x, 1
  %c = icmp eq i64 %y, 0
  %cz = zext i1 %c to i64
  %a = or i64 %xa, %cz
  ret i64 %a
}

define i64 @ori64_eq_c(i64 %x, i32 %y) {
; CHECK-LABEL: ori64_eq_c:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    cmp r2, #0
; CHECK-NEXT:    and r0, r0, #1
; CHECK-NEXT:    cset r1, eq
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    movs r1, #0
; CHECK-NEXT:    bx lr
  %xa = and i64 %x, 1
  %c = icmp eq i32 %y, 0
  %cz = zext i1 %c to i64
  %a = or i64 %cz, %xa
  ret i64 %a
}

define i64 @andi64_ne(i8 %x, i8 %y) {
; CHECK-LABEL: andi64_ne:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    tst.w r0, #255
; CHECK-NEXT:    cset r0, eq
; CHECK-NEXT:    tst.w r1, #255
; CHECK-NEXT:    csel r0, zr, r0, eq
; CHECK-NEXT:    movs r1, #0
; CHECK-NEXT:    bx lr
  %xc = icmp eq i8 %x, 0
  %xa = zext i1 %xc to i64
  %c = icmp ne i8 %y, 0
  %cz = zext i1 %c to i64
  %a = and i64 %xa, %cz
  ret i64 %a
}

; Check for multiple uses on the csinc
define i32 @t5(i32 %f.0, i32 %call) {
; CHECK-LABEL: t5:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    cmp r1, #0
; CHECK-NEXT:    cset r1, ne
; CHECK-NEXT:    cmp r0, #13
; CHECK-NEXT:    cset r0, eq
; CHECK-NEXT:    and.w r2, r0, r1
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    eor r0, r0, #1
; CHECK-NEXT:    orrs r0, r2
; CHECK-NEXT:    bx lr
entry:
  %tobool1.i = icmp ne i32 %call, 0
  %cmp = icmp eq i32 %f.0, 13
  %or.cond = select i1 %cmp, i1 %tobool1.i, i1 false
  %or.cond7.not = select i1 %cmp, i1 true, i1 %tobool1.i
  %or.cond7.not.not = xor i1 %or.cond7.not, true
  %not.or.cond12 = select i1 %or.cond, i1 true, i1 %or.cond7.not.not
  %g.0 = zext i1 %not.or.cond12 to i32
  ret i32 %g.0
}

define i32 @test(i32 %a, i32 %b) {
; CHECK-LABEL: test:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    movs r2, #1
; CHECK-NEXT:    cmp r1, r0
; CHECK-NEXT:    lsr.w r2, r2, r1
; CHECK-NEXT:    csinc r0, r2, zr, le
; CHECK-NEXT:    bx lr
entry:
  %cmp = icmp sgt i32 %b, %a
  %b.op = lshr i32 1, %b
  %shr = select i1 %cmp, i32 1, i32 %b.op
  ret i32 %shr
}

