; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --verify-machineinstrs -mtriple powerpc-ibm-aix-xcoff \
; RUN:   -ppc-asm-full-reg-names -mcpu=pwr8 < %s | \
; RUN: FileCheck %s --check-prefixes=CHECK,CHECK32
; RUN: llc --verify-machineinstrs -mtriple powerpc64-ibm-aix-xcoff \
; RUN:   -ppc-asm-full-reg-names -mcpu=pwr8 < %s | \
; RUN: FileCheck %s --check-prefixes=CHECK,CHECK64

define ptr @lower_args(ptr %_0, i32 %0, i32 %1, i32 %2, i32 %3, ptr %4, ptr %5, i64 %6, i24 %7) {
; CHECK-LABEL: lower_args:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    blr
entry:
  ret ptr %_0
}

define i32 @lower_args_withops_zeroext(i32 %a, i32 %b, i32 %c, i32 %d, i32 %e, i32 %f, i32 %g, i32 %h, i24 %i) {
; CHECK32-LABEL: lower_args_withops_zeroext:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    lwz r3, 56(r1)
; CHECK32-NEXT:    addi r3, r3, 255
; CHECK32-NEXT:    clrlwi r3, r3, 8
; CHECK32-NEXT:    blr
;
; CHECK64-LABEL: lower_args_withops_zeroext:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    lwz r3, 116(r1)
; CHECK64-NEXT:    addi r3, r3, 255
; CHECK64-NEXT:    clrldi r3, r3, 40
; CHECK64-NEXT:    blr
entry:
  %0 = add i24 %i, 255
  %1 = zext i24 %0 to i32
  ret i32 %1
}

define i32 @lower_args_withops_signext(i32 %a, i32 %b, i32 %c, i32 %d, i32 %e, i32 %f, i32 %g, i32 %h, i24 signext %i) {
; CHECK32-LABEL: lower_args_withops_signext:
; CHECK32:       # %bb.0: # %entry
; CHECK32-NEXT:    lwz r3, 56(r1)
; CHECK32-NEXT:    slwi r3, r3, 8
; CHECK32-NEXT:    srawi r3, r3, 8
; CHECK32-NEXT:    slwi r3, r3, 8
; CHECK32-NEXT:    addi r3, r3, 22272
; CHECK32-NEXT:    srawi r3, r3, 8
; CHECK32-NEXT:    blr
;
; CHECK64-LABEL: lower_args_withops_signext:
; CHECK64:       # %bb.0: # %entry
; CHECK64-NEXT:    lwz r3, 116(r1)
; CHECK64-NEXT:    slwi r3, r3, 8
; CHECK64-NEXT:    srawi r3, r3, 8
; CHECK64-NEXT:    addi r3, r3, 87
; CHECK64-NEXT:    sldi r3, r3, 40
; CHECK64-NEXT:    sradi r3, r3, 40
; CHECK64-NEXT:    blr
entry:
  %0 = add i24 %i, 87
  %1 = sext i24 %0 to i32
  ret i32 %1
}
