// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package util

import (
	"fmt"
)

func jsonMap[T any](data any, key string) T {
	return jsonGet[T](jsonGetObject(data)[key])
}

func jsonGetObject(data any) map[string]any {
	switch v := data.(type) {
	case nil:
		return nil
	case map[string]any:
		return v
	default:
		panic(fmt.Errorf("unexpected %T", data))
	}
}

func jsonElement[T any](data any, index int) T {
	return jsonGet[T](jsonGetArray(data)[index])
}

func jsonGetArray(data any) []any {
	switch v := data.(type) {
	case nil:
		return nil
	case []any:
		return v
	default:
		panic(fmt.Errorf("unexpected %T", data))
	}
}

func jsonGet[T any](data any) T {
	switch v := data.(type) {
	case nil:
		var s T
		return s
	case T:
		return v
	default:
		panic(fmt.Errorf("unexpected %T", data))
	}
}
