// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package options

import (
	"code.forgejo.org/f3/gof3/v3/options/auth"
	"code.forgejo.org/f3/gof3/v3/options/cli"
	"code.forgejo.org/f3/gof3/v3/options/http"
	"code.forgejo.org/f3/gof3/v3/options/logger"
	"code.forgejo.org/f3/gof3/v3/options/url"
)

type (
	CLIInterface    cli.Interface
	LoggerInterface logger.Interface
	URLInterface    url.Interface
	AuthInterface   auth.Interface
	HTTPInterface   http.Interface
)

type Interface interface {
	GetName() string
	SetName(string)
}
