# Generated by Django 4.2.16 on 2024-12-29 01:12

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import debusine.assets
import debusine.db.constraints
from debusine.db.migrations._utils import ReloadModel


class Migration(migrations.Migration):

    dependencies = [
        ('db', '0115_workrequest_workflow_runtime_status_use_value'),
    ]

    operations = [
        migrations.CreateModel(
            name='Asset',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'category',
                    models.CharField(
                        choices=[
                            ('debusine:signing-key', 'debusine:signing-key')
                        ],
                        max_length=255,
                    ),
                ),
                ('data', models.JSONField(default=dict)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                (
                    'created_by',
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    'created_by_work_request',
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to='db.workrequest',
                    ),
                ),
                (
                    'workspace',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to='db.workspace',
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='AssetUsage',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'asset',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='usage',
                        to='db.asset',
                    ),
                ),
                (
                    'workspace',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='asset_usage',
                        to='db.workspace',
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='AssetUsageRole',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'role',
                    models.CharField(
                        choices=[('signer', 'Signer')], max_length=16
                    ),
                ),
                (
                    'group',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='asset_usage_roles',
                        to='db.group',
                    ),
                ),
                (
                    'resource',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='roles',
                        to='db.assetusage',
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='AssetRole',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'role',
                    models.CharField(
                        choices=[('owner', 'Owner')], max_length=16
                    ),
                ),
                (
                    'group',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='asset_roles',
                        to='db.group',
                    ),
                ),
                (
                    'resource',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name='roles',
                        to='db.asset',
                    ),
                ),
            ],
        ),
        migrations.AddConstraint(
            model_name='asset',
            constraint=debusine.db.constraints.JsonDataUniqueConstraint(
                condition=models.Q(
                    (
                        'category',
                        debusine.assets.AssetCategory['SIGNING_KEY'],
                    )
                ),
                fields=('category', "data->>'fingerprint'"),
                name='db_asset_unique_signing_key_fingerprints',
                nulls_distinct=False,
            ),
        ),
        ReloadModel(("db", "collectionitemmatchconstraint")),
    ]
