# DXMT

A Metal-based translation layer for Direct3D 11 and 10 which allows running 3D applications on macOS using Wine.

For the current status of the project, please refer to the [project wiki](https://github.com/3Shain/dxmt/wiki).

The most recent development builds can be found [here](https://github.com/3Shain/dxmt/actions).

<!--

TODO: rework this section

## How to use

**DXMT is not ready for end-users**, albeit there is a [guide](https://github.com/3Shain/dxmt/wiki/DXMT-Installation-Guide-for-Geeks) for knowledged users.

-->

### Logs
When used with Wine, DXMT will print log messages to `stderr`. Additionally, standalone log files can optionally be generated by setting the `DXMT_LOG_PATH` variable, where log files in the given directory will be called `app_d3d11.log`, `app_dxgi.log` etc., where `app` is the name of the game executable.

### Config file

- `DXMT_CONFIG_FILE=/xxx/dxmt.conf` Sets path to the configuration file. Check `dxmt.conf` in the project directory for reference.
- `DXMT_CONFIG="d3d11.preferredMaxFrameRate=30;"` Can be used to set config variables through the environment instead of a configuration file using the same syntax. `;` is used as a seperator.

### MetalFX Spatial Upscaling for Swapchain

Set environment variable `DXMT_METALFX_SPATIAL_SWAPCHAIN=1` to enable MetalFX spatial upscaler on output swapchain. By default it will double the output resolution. Set `d3d11.metalSpatialUpscaleFactor` to a value between 1.0 and 2.0 to change the scale factor.

### Metal Frame Pacing

`d3d11.preferredMaxFrameRate` can be set to enforce the application's frame pacing being controled by Metal. The value must be a factor of your display's refresh rate. (e.g. 15/30/40/60/120 is valid for a 120hz display).

### Debugging
The following environment variables can be used for **debugging** purposes.
- `MTL_SHADER_VALIDATION=1` Enable Metal shader validation layer
- `MTL_DEBUG_LAYER=1` Enable Metal API validation layer
- `MTL_CAPTURE_ENABLED=1` Enable Metal frame capture
- `DXMT_CAPTURE_EXECUTABLE="the executable name without extension"` Must be set to enable Metal frame capture. Press F10 to generate a capture. The captured result will be stored in the same directory as the executable.
- `DXMT_CAPTURE_FRAME=n` Automatically capture n-th frame. Useful for debugging a replay.
- `DXMT_LOG_LEVEL=none|error|warn|info|debug` Controls message logging.
- `DXMT_LOG_PATH=/some/directory` Changes path where log files are stored. Set to `none` to disable log file creation entirely, without disabling logging.

## Build

### Requirements:
- Meson 1.3+ (for project build system)
- CMake 3.27+ (for LLVM dependencies)
- Xcode 15+

### Instructions

After cloning this repository, inside the DXMT directory, run
```sh
./configure.sh
meson setup --cross-file build-win64.txt --native-file build-osx.txt -Dnative_llvm_path=toolchains/llvm-darwin -Dwine_install_path=toolchains/wine build
```
`./configure.sh` will take some time (~1 hour) to configure the development environment, you only run it once.

Then run the follow command to actually compile DXMT
```sh
meson compile -C build
```

#### Native build

As an alternative for the default wine based build DXMT can be built natively on macOS for Apple Silicon to allow games to be ported more easily to this platform. In order to do this run the following commands after cloning the repository
```sh
./configure.sh --native
meson setup --native-file build-osx.txt -Ddxmt_native=true -Dnative_llvm_path=toolchains/llvm-darwin build
meson compile -C build
```
