#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Triple Triad Gold
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251013.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='triple-triad-gold'
GAME_NAME='Triple Triad Gold'

ARCHIVE_BASE_0_NAME='ttg09.zip'
ARCHIVE_BASE_0_MD5='ec517c23236f2ad9217e1488f27b3dab'
ARCHIVE_BASE_0_SIZE='4400'
ARCHIVE_BASE_0_VERSION='0.9-qhimm1'
ARCHIVE_BASE_0_URL='https://ttg.qhimm.com/'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
*.dll
*.exe'
CONTENT_GAME_DATA_FILES='
*.dat'

USER_PERSISTENT_FILES='
settings.dat'

## TODO: Check if this winetricks verb is still required with WINE ≥ 10.0.
WINE_WINETRICKS_VERBS='mfc42'

APP_MAIN_EXE='Triple Triad Gold.exe'
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --name=128'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
